package Monitoring::GLPlugin::SNMP::MibsAndOids::IPMIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'IP-MIB'} = {
  url => '',
  name => 'IP-MIB',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::mib_ids->{'IP-MIB'} =
    '1.3.6.1.2.1.4';

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'IP-MIB'} = {
  'ip' => '1.3.6.1.2.1.4',
  'ipForwarding' => '1.3.6.1.2.1.4.1',
  'ipForwardingDefinition' => 'IP-MIB::ipForwarding',
  'ipDefaultTTL' => '1.3.6.1.2.1.4.2',
  'ipInReceives' => '1.3.6.1.2.1.4.3',
  'ipInHdrErrors' => '1.3.6.1.2.1.4.4',
  'ipInAddrErrors' => '1.3.6.1.2.1.4.5',
  'ipForwDatagrams' => '1.3.6.1.2.1.4.6',
  'ipInUnknownProtos' => '1.3.6.1.2.1.4.7',
  'ipInDiscards' => '1.3.6.1.2.1.4.8',
  'ipInDelivers' => '1.3.6.1.2.1.4.9',
  'ipOutRequests' => '1.3.6.1.2.1.4.10',
  'ipOutDiscards' => '1.3.6.1.2.1.4.11',
  'ipOutNoRoutes' => '1.3.6.1.2.1.4.12',
  'ipReasmTimeout' => '1.3.6.1.2.1.4.13',
  'ipReasmReqds' => '1.3.6.1.2.1.4.14',
  'ipReasmOKs' => '1.3.6.1.2.1.4.15',
  'ipReasmFails' => '1.3.6.1.2.1.4.16',
  'ipFragOKs' => '1.3.6.1.2.1.4.17',
  'ipFragFails' => '1.3.6.1.2.1.4.18',
  'ipFragCreates' => '1.3.6.1.2.1.4.19',
  'ipAddrTable' => '1.3.6.1.2.1.4.20',
  'ipAddrEntry' => '1.3.6.1.2.1.4.20.1',
  'ipAdEntAddr' => '1.3.6.1.2.1.4.20.1.1',
  'ipAdEntIfIndex' => '1.3.6.1.2.1.4.20.1.2',
  'ipAdEntNetMask' => '1.3.6.1.2.1.4.20.1.3',
  'ipAdEntBcastAddr' => '1.3.6.1.2.1.4.20.1.4',
  'ipAdEntReasmMaxSize' => '1.3.6.1.2.1.4.20.1.5',
  ############################################################
  # die ist eigentlich aus dieser MIB rausgeflogen. weil aber
  # im hintersten winkel von check_nwc_health ein fallback
  # auf diese tabelle zugreift, will ich nicht so sein.
  'ipRouteTable' => '1.3.6.1.2.1.4.21',
  'ipRouteEntry' => '1.3.6.1.2.1.4.21.1',
  'ipRouteDest' => '1.3.6.1.2.1.4.21.1.1',
  'ipRouteIfIndex' => '1.3.6.1.2.1.4.21.1.2',
  'ipRouteMetric1' => '1.3.6.1.2.1.4.21.1.3',
  'ipRouteMetric2' => '1.3.6.1.2.1.4.21.1.4',
  'ipRouteMetric3' => '1.3.6.1.2.1.4.21.1.5',
  'ipRouteMetric4' => '1.3.6.1.2.1.4.21.1.6',
  'ipRouteNextHop' => '1.3.6.1.2.1.4.21.1.7',
  'ipRouteType' => '1.3.6.1.2.1.4.21.1.8',
  'ipRouteProto' => '1.3.6.1.2.1.4.21.1.9',
  'ipRouteAge' => '1.3.6.1.2.1.4.21.1.10',
  'ipRouteMask' => '1.3.6.1.2.1.4.21.1.11',
  'ipRouteMetric5' => '1.3.6.1.2.1.4.21.1.12',
  'ipRouteInfo' => '1.3.6.1.2.1.4.21.1.13',
  ############################################################
  'ipNetToMediaTable' => '1.3.6.1.2.1.4.22',
  'ipNetToMediaEntry' => '1.3.6.1.2.1.4.22.1',
  'ipNetToMediaIfIndex' => '1.3.6.1.2.1.4.22.1.1',
  'ipNetToMediaPhysAddress' => '1.3.6.1.2.1.4.22.1.2',
  'ipNetToMediaNetAddress' => '1.3.6.1.2.1.4.22.1.3',
  'ipNetToMediaType' => '1.3.6.1.2.1.4.22.1.4',
  'ipNetToMediaTypeDefinition' => 'IP-MIB::ipNetToMediaType',
  'ipRoutingDiscards' => '1.3.6.1.2.1.4.23',
  'ipv6IpForwarding' => '1.3.6.1.2.1.4.25',
  'ipv6IpForwardingDefinition' => 'IP-MIB::ipv6IpForwarding',
  'ipv6IpDefaultHopLimit' => '1.3.6.1.2.1.4.26',
  'ipv4InterfaceTableLastChange' => '1.3.6.1.2.1.4.27',
  'ipv4InterfaceTable' => '1.3.6.1.2.1.4.28',
  'ipv4InterfaceEntry' => '1.3.6.1.2.1.4.28.1',
  'ipv4InterfaceIfIndex' => '1.3.6.1.2.1.4.28.1.1',
  'ipv4InterfaceReasmMaxSize' => '1.3.6.1.2.1.4.28.1.2',
  'ipv4InterfaceEnableStatus' => '1.3.6.1.2.1.4.28.1.3',
  'ipv4InterfaceEnableStatusDefinition' => 'IP-MIB::ipv4InterfaceEnableStatus',
  'ipv4InterfaceRetransmitTime' => '1.3.6.1.2.1.4.28.1.4',
  'ipv6InterfaceTableLastChange' => '1.3.6.1.2.1.4.29',
  'ipv6InterfaceTable' => '1.3.6.1.2.1.4.30',
  'ipv6InterfaceEntry' => '1.3.6.1.2.1.4.30.1',
  'ipv6InterfaceIfIndex' => '1.3.6.1.2.1.4.30.1.1',
  'ipv6InterfaceReasmMaxSize' => '1.3.6.1.2.1.4.30.1.2',
  'ipv6InterfaceIdentifier' => '1.3.6.1.2.1.4.30.1.3',
  'ipv6InterfaceEnableStatus' => '1.3.6.1.2.1.4.30.1.5',
  'ipv6InterfaceEnableStatusDefinition' => 'IP-MIB::ipv6InterfaceEnableStatus',
  'ipv6InterfaceReachableTime' => '1.3.6.1.2.1.4.30.1.6',
  'ipv6InterfaceRetransmitTime' => '1.3.6.1.2.1.4.30.1.7',
  'ipv6InterfaceForwarding' => '1.3.6.1.2.1.4.30.1.8',
  'ipv6InterfaceForwardingDefinition' => 'IP-MIB::ipv6InterfaceForwarding',
  'ipTrafficStats' => '1.3.6.1.2.1.4.31',
  'ipSystemStatsTable' => '1.3.6.1.2.1.4.31.1',
  'ipSystemStatsEntry' => '1.3.6.1.2.1.4.31.1.1',
  'ipSystemStatsIPVersion' => '1.3.6.1.2.1.4.31.1.1.1',
  'ipSystemStatsInReceives' => '1.3.6.1.2.1.4.31.1.1.3',
  'ipSystemStatsHCInReceives' => '1.3.6.1.2.1.4.31.1.1.4',
  'ipSystemStatsInOctets' => '1.3.6.1.2.1.4.31.1.1.5',
  'ipSystemStatsHCInOctets' => '1.3.6.1.2.1.4.31.1.1.6',
  'ipSystemStatsInHdrErrors' => '1.3.6.1.2.1.4.31.1.1.7',
  'ipSystemStatsInNoRoutes' => '1.3.6.1.2.1.4.31.1.1.8',
  'ipSystemStatsInAddrErrors' => '1.3.6.1.2.1.4.31.1.1.9',
  'ipSystemStatsInUnknownProtos' => '1.3.6.1.2.1.4.31.1.1.10',
  'ipSystemStatsInTruncatedPkts' => '1.3.6.1.2.1.4.31.1.1.11',
  'ipSystemStatsInForwDatagrams' => '1.3.6.1.2.1.4.31.1.1.12',
  'ipSystemStatsHCInForwDatagrams' => '1.3.6.1.2.1.4.31.1.1.13',
  'ipSystemStatsReasmReqds' => '1.3.6.1.2.1.4.31.1.1.14',
  'ipSystemStatsReasmOKs' => '1.3.6.1.2.1.4.31.1.1.15',
  'ipSystemStatsReasmFails' => '1.3.6.1.2.1.4.31.1.1.16',
  'ipSystemStatsInDiscards' => '1.3.6.1.2.1.4.31.1.1.17',
  'ipSystemStatsInDelivers' => '1.3.6.1.2.1.4.31.1.1.18',
  'ipSystemStatsHCInDelivers' => '1.3.6.1.2.1.4.31.1.1.19',
  'ipSystemStatsOutRequests' => '1.3.6.1.2.1.4.31.1.1.20',
  'ipSystemStatsHCOutRequests' => '1.3.6.1.2.1.4.31.1.1.21',
  'ipSystemStatsOutNoRoutes' => '1.3.6.1.2.1.4.31.1.1.22',
  'ipSystemStatsOutForwDatagrams' => '1.3.6.1.2.1.4.31.1.1.23',
  'ipSystemStatsHCOutForwDatagrams' => '1.3.6.1.2.1.4.31.1.1.24',
  'ipSystemStatsOutDiscards' => '1.3.6.1.2.1.4.31.1.1.25',
  'ipSystemStatsOutFragReqds' => '1.3.6.1.2.1.4.31.1.1.26',
  'ipSystemStatsOutFragOKs' => '1.3.6.1.2.1.4.31.1.1.27',
  'ipSystemStatsOutFragFails' => '1.3.6.1.2.1.4.31.1.1.28',
  'ipSystemStatsOutFragCreates' => '1.3.6.1.2.1.4.31.1.1.29',
  'ipSystemStatsOutTransmits' => '1.3.6.1.2.1.4.31.1.1.30',
  'ipSystemStatsHCOutTransmits' => '1.3.6.1.2.1.4.31.1.1.31',
  'ipSystemStatsOutOctets' => '1.3.6.1.2.1.4.31.1.1.32',
  'ipSystemStatsHCOutOctets' => '1.3.6.1.2.1.4.31.1.1.33',
  'ipSystemStatsInMcastPkts' => '1.3.6.1.2.1.4.31.1.1.34',
  'ipSystemStatsHCInMcastPkts' => '1.3.6.1.2.1.4.31.1.1.35',
  'ipSystemStatsInMcastOctets' => '1.3.6.1.2.1.4.31.1.1.36',
  'ipSystemStatsHCInMcastOctets' => '1.3.6.1.2.1.4.31.1.1.37',
  'ipSystemStatsOutMcastPkts' => '1.3.6.1.2.1.4.31.1.1.38',
  'ipSystemStatsHCOutMcastPkts' => '1.3.6.1.2.1.4.31.1.1.39',
  'ipSystemStatsOutMcastOctets' => '1.3.6.1.2.1.4.31.1.1.40',
  'ipSystemStatsHCOutMcastOctets' => '1.3.6.1.2.1.4.31.1.1.41',
  'ipSystemStatsInBcastPkts' => '1.3.6.1.2.1.4.31.1.1.42',
  'ipSystemStatsHCInBcastPkts' => '1.3.6.1.2.1.4.31.1.1.43',
  'ipSystemStatsOutBcastPkts' => '1.3.6.1.2.1.4.31.1.1.44',
  'ipSystemStatsHCOutBcastPkts' => '1.3.6.1.2.1.4.31.1.1.45',
  'ipSystemStatsDiscontinuityTime' => '1.3.6.1.2.1.4.31.1.1.46',
  'ipSystemStatsRefreshRate' => '1.3.6.1.2.1.4.31.1.1.47',
  'ipIfStatsTableLastChange' => '1.3.6.1.2.1.4.31.2',
  'ipIfStatsTable' => '1.3.6.1.2.1.4.31.3',
  'ipIfStatsEntry' => '1.3.6.1.2.1.4.31.3.1',
  'ipIfStatsIPVersion' => '1.3.6.1.2.1.4.31.3.1.1',
  'ipIfStatsIfIndex' => '1.3.6.1.2.1.4.31.3.1.2',
  'ipIfStatsInReceives' => '1.3.6.1.2.1.4.31.3.1.3',
  'ipIfStatsHCInReceives' => '1.3.6.1.2.1.4.31.3.1.4',
  'ipIfStatsInOctets' => '1.3.6.1.2.1.4.31.3.1.5',
  'ipIfStatsHCInOctets' => '1.3.6.1.2.1.4.31.3.1.6',
  'ipIfStatsInHdrErrors' => '1.3.6.1.2.1.4.31.3.1.7',
  'ipIfStatsInNoRoutes' => '1.3.6.1.2.1.4.31.3.1.8',
  'ipIfStatsInAddrErrors' => '1.3.6.1.2.1.4.31.3.1.9',
  'ipIfStatsInUnknownProtos' => '1.3.6.1.2.1.4.31.3.1.10',
  'ipIfStatsInTruncatedPkts' => '1.3.6.1.2.1.4.31.3.1.11',
  'ipIfStatsInForwDatagrams' => '1.3.6.1.2.1.4.31.3.1.12',
  'ipIfStatsHCInForwDatagrams' => '1.3.6.1.2.1.4.31.3.1.13',
  'ipIfStatsReasmReqds' => '1.3.6.1.2.1.4.31.3.1.14',
  'ipIfStatsReasmOKs' => '1.3.6.1.2.1.4.31.3.1.15',
  'ipIfStatsReasmFails' => '1.3.6.1.2.1.4.31.3.1.16',
  'ipIfStatsInDiscards' => '1.3.6.1.2.1.4.31.3.1.17',
  'ipIfStatsInDelivers' => '1.3.6.1.2.1.4.31.3.1.18',
  'ipIfStatsHCInDelivers' => '1.3.6.1.2.1.4.31.3.1.19',
  'ipIfStatsOutRequests' => '1.3.6.1.2.1.4.31.3.1.20',
  'ipIfStatsHCOutRequests' => '1.3.6.1.2.1.4.31.3.1.21',
  'ipIfStatsOutForwDatagrams' => '1.3.6.1.2.1.4.31.3.1.23',
  'ipIfStatsHCOutForwDatagrams' => '1.3.6.1.2.1.4.31.3.1.24',
  'ipIfStatsOutDiscards' => '1.3.6.1.2.1.4.31.3.1.25',
  'ipIfStatsOutFragReqds' => '1.3.6.1.2.1.4.31.3.1.26',
  'ipIfStatsOutFragOKs' => '1.3.6.1.2.1.4.31.3.1.27',
  'ipIfStatsOutFragFails' => '1.3.6.1.2.1.4.31.3.1.28',
  'ipIfStatsOutFragCreates' => '1.3.6.1.2.1.4.31.3.1.29',
  'ipIfStatsOutTransmits' => '1.3.6.1.2.1.4.31.3.1.30',
  'ipIfStatsHCOutTransmits' => '1.3.6.1.2.1.4.31.3.1.31',
  'ipIfStatsOutOctets' => '1.3.6.1.2.1.4.31.3.1.32',
  'ipIfStatsHCOutOctets' => '1.3.6.1.2.1.4.31.3.1.33',
  'ipIfStatsInMcastPkts' => '1.3.6.1.2.1.4.31.3.1.34',
  'ipIfStatsHCInMcastPkts' => '1.3.6.1.2.1.4.31.3.1.35',
  'ipIfStatsInMcastOctets' => '1.3.6.1.2.1.4.31.3.1.36',
  'ipIfStatsHCInMcastOctets' => '1.3.6.1.2.1.4.31.3.1.37',
  'ipIfStatsOutMcastPkts' => '1.3.6.1.2.1.4.31.3.1.38',
  'ipIfStatsHCOutMcastPkts' => '1.3.6.1.2.1.4.31.3.1.39',
  'ipIfStatsOutMcastOctets' => '1.3.6.1.2.1.4.31.3.1.40',
  'ipIfStatsHCOutMcastOctets' => '1.3.6.1.2.1.4.31.3.1.41',
  'ipIfStatsInBcastPkts' => '1.3.6.1.2.1.4.31.3.1.42',
  'ipIfStatsHCInBcastPkts' => '1.3.6.1.2.1.4.31.3.1.43',
  'ipIfStatsOutBcastPkts' => '1.3.6.1.2.1.4.31.3.1.44',
  'ipIfStatsHCOutBcastPkts' => '1.3.6.1.2.1.4.31.3.1.45',
  'ipIfStatsDiscontinuityTime' => '1.3.6.1.2.1.4.31.3.1.46',
  'ipIfStatsRefreshRate' => '1.3.6.1.2.1.4.31.3.1.47',
  'ipAddressPrefixTable' => '1.3.6.1.2.1.4.32',
  'ipAddressPrefixEntry' => '1.3.6.1.2.1.4.32.1',
  'ipAddressPrefixIfIndex' => '1.3.6.1.2.1.4.32.1.1',
  'ipAddressPrefixType' => '1.3.6.1.2.1.4.32.1.2',
  'ipAddressPrefixPrefix' => '1.3.6.1.2.1.4.32.1.3',
  'ipAddressPrefixLength' => '1.3.6.1.2.1.4.32.1.4',
  'ipAddressPrefixOrigin' => '1.3.6.1.2.1.4.32.1.5',
  'ipAddressPrefixOriginDefinition' => 'IP-MIB::IpAddressPrefixOriginTC',
  'ipAddressPrefixOnLinkFlag' => '1.3.6.1.2.1.4.32.1.6',
  'ipAddressPrefixAutonomousFlag' => '1.3.6.1.2.1.4.32.1.7',
  'ipAddressPrefixAdvPreferredLifetime' => '1.3.6.1.2.1.4.32.1.8',
  'ipAddressPrefixAdvValidLifetime' => '1.3.6.1.2.1.4.32.1.9',
  'ipAddressSpinLock' => '1.3.6.1.2.1.4.33',
  'ipAddressTable' => '1.3.6.1.2.1.4.34',
  'ipAddressEntry' => '1.3.6.1.2.1.4.34.1',
  'ipAddressAddrType' => '1.3.6.1.2.1.4.34.1.1',
  'ipAddressAddr' => '1.3.6.1.2.1.4.34.1.2',
  'ipAddressIfIndex' => '1.3.6.1.2.1.4.34.1.3',
  'ipAddressType' => '1.3.6.1.2.1.4.34.1.4',
  'ipAddressTypeDefinition' => 'IP-MIB::ipAddressType',
  'ipAddressPrefix' => '1.3.6.1.2.1.4.34.1.5',
  'ipAddressOrigin' => '1.3.6.1.2.1.4.34.1.6',
  'ipAddressOriginDefinition' => 'IP-MIB::IpAddressOriginTC',
  'ipAddressStatus' => '1.3.6.1.2.1.4.34.1.7',
  'ipAddressStatusDefinition' => 'IP-MIB::IpAddressStatusTC',
  'ipAddressCreated' => '1.3.6.1.2.1.4.34.1.8',
  'ipAddressLastChanged' => '1.3.6.1.2.1.4.34.1.9',
  'ipAddressRowStatus' => '1.3.6.1.2.1.4.34.1.10',
  'ipAddressStorageType' => '1.3.6.1.2.1.4.34.1.11',
  'ipNetToPhysicalTable' => '1.3.6.1.2.1.4.35',
  'ipNetToPhysicalEntry' => '1.3.6.1.2.1.4.35.1',
  'ipNetToPhysicalIfIndex' => '1.3.6.1.2.1.4.35.1.1',
  'ipNetToPhysicalNetAddressType' => '1.3.6.1.2.1.4.35.1.2',
  'ipNetToPhysicalNetAddress' => '1.3.6.1.2.1.4.35.1.3',
  'ipNetToPhysicalPhysAddress' => '1.3.6.1.2.1.4.35.1.4',
  'ipNetToPhysicalLastUpdated' => '1.3.6.1.2.1.4.35.1.5',
  'ipNetToPhysicalType' => '1.3.6.1.2.1.4.35.1.6',
  'ipNetToPhysicalTypeDefinition' => 'IP-MIB::ipNetToPhysicalType',
  'ipNetToPhysicalState' => '1.3.6.1.2.1.4.35.1.7',
  'ipNetToPhysicalStateDefinition' => 'IP-MIB::ipNetToPhysicalState',
  'ipNetToPhysicalRowStatus' => '1.3.6.1.2.1.4.35.1.8',
  'ipv6ScopeZoneIndexTable' => '1.3.6.1.2.1.4.36',
  'ipv6ScopeZoneIndexEntry' => '1.3.6.1.2.1.4.36.1',
  'ipv6ScopeZoneIndexIfIndex' => '1.3.6.1.2.1.4.36.1.1',
  'ipv6ScopeZoneIndexLinkLocal' => '1.3.6.1.2.1.4.36.1.2',
  'ipv6ScopeZoneIndex3' => '1.3.6.1.2.1.4.36.1.3',
  'ipv6ScopeZoneIndexAdminLocal' => '1.3.6.1.2.1.4.36.1.4',
  'ipv6ScopeZoneIndexSiteLocal' => '1.3.6.1.2.1.4.36.1.5',
  'ipv6ScopeZoneIndex6' => '1.3.6.1.2.1.4.36.1.6',
  'ipv6ScopeZoneIndex7' => '1.3.6.1.2.1.4.36.1.7',
  'ipv6ScopeZoneIndexOrganizationLocal' => '1.3.6.1.2.1.4.36.1.8',
  'ipv6ScopeZoneIndex9' => '1.3.6.1.2.1.4.36.1.9',
  'ipv6ScopeZoneIndexA' => '1.3.6.1.2.1.4.36.1.10',
  'ipv6ScopeZoneIndexB' => '1.3.6.1.2.1.4.36.1.11',
  'ipv6ScopeZoneIndexC' => '1.3.6.1.2.1.4.36.1.12',
  'ipv6ScopeZoneIndexD' => '1.3.6.1.2.1.4.36.1.13',
  'ipDefaultRouterTable' => '1.3.6.1.2.1.4.37',
  'ipDefaultRouterEntry' => '1.3.6.1.2.1.4.37.1',
  'ipDefaultRouterAddressType' => '1.3.6.1.2.1.4.37.1.1',
  'ipDefaultRouterAddress' => '1.3.6.1.2.1.4.37.1.2',
  'ipDefaultRouterIfIndex' => '1.3.6.1.2.1.4.37.1.3',
  'ipDefaultRouterLifetime' => '1.3.6.1.2.1.4.37.1.4',
  'ipDefaultRouterPreference' => '1.3.6.1.2.1.4.37.1.5',
  'ipDefaultRouterPreferenceDefinition' => 'IP-MIB::ipDefaultRouterPreference',
  'ipv6RouterAdvertSpinLock' => '1.3.6.1.2.1.4.38',
  'ipv6RouterAdvertTable' => '1.3.6.1.2.1.4.39',
  'ipv6RouterAdvertEntry' => '1.3.6.1.2.1.4.39.1',
  'ipv6RouterAdvertIfIndex' => '1.3.6.1.2.1.4.39.1.1',
  'ipv6RouterAdvertSendAdverts' => '1.3.6.1.2.1.4.39.1.2',
  'ipv6RouterAdvertMaxInterval' => '1.3.6.1.2.1.4.39.1.3',
  'ipv6RouterAdvertMinInterval' => '1.3.6.1.2.1.4.39.1.4',
  'ipv6RouterAdvertManagedFlag' => '1.3.6.1.2.1.4.39.1.5',
  'ipv6RouterAdvertOtherConfigFlag' => '1.3.6.1.2.1.4.39.1.6',
  'ipv6RouterAdvertLinkMTU' => '1.3.6.1.2.1.4.39.1.7',
  'ipv6RouterAdvertReachableTime' => '1.3.6.1.2.1.4.39.1.8',
  'ipv6RouterAdvertRetransmitTime' => '1.3.6.1.2.1.4.39.1.9',
  'ipv6RouterAdvertCurHopLimit' => '1.3.6.1.2.1.4.39.1.10',
  'ipv6RouterAdvertDefaultLifetime' => '1.3.6.1.2.1.4.39.1.11',
  'ipv6RouterAdvertRowStatus' => '1.3.6.1.2.1.4.39.1.12',
  'icmp' => '1.3.6.1.2.1.5',
  'icmpInMsgs' => '1.3.6.1.2.1.5.1',
  'icmpInErrors' => '1.3.6.1.2.1.5.2',
  'icmpInDestUnreachs' => '1.3.6.1.2.1.5.3',
  'icmpInTimeExcds' => '1.3.6.1.2.1.5.4',
  'icmpInParmProbs' => '1.3.6.1.2.1.5.5',
  'icmpInSrcQuenchs' => '1.3.6.1.2.1.5.6',
  'icmpInRedirects' => '1.3.6.1.2.1.5.7',
  'icmpInEchos' => '1.3.6.1.2.1.5.8',
  'icmpInEchoReps' => '1.3.6.1.2.1.5.9',
  'icmpInTimestamps' => '1.3.6.1.2.1.5.10',
  'icmpInTimestampReps' => '1.3.6.1.2.1.5.11',
  'icmpInAddrMasks' => '1.3.6.1.2.1.5.12',
  'icmpInAddrMaskReps' => '1.3.6.1.2.1.5.13',
  'icmpOutMsgs' => '1.3.6.1.2.1.5.14',
  'icmpOutErrors' => '1.3.6.1.2.1.5.15',
  'icmpOutDestUnreachs' => '1.3.6.1.2.1.5.16',
  'icmpOutTimeExcds' => '1.3.6.1.2.1.5.17',
  'icmpOutParmProbs' => '1.3.6.1.2.1.5.18',
  'icmpOutSrcQuenchs' => '1.3.6.1.2.1.5.19',
  'icmpOutRedirects' => '1.3.6.1.2.1.5.20',
  'icmpOutEchos' => '1.3.6.1.2.1.5.21',
  'icmpOutEchoReps' => '1.3.6.1.2.1.5.22',
  'icmpOutTimestamps' => '1.3.6.1.2.1.5.23',
  'icmpOutTimestampReps' => '1.3.6.1.2.1.5.24',
  'icmpOutAddrMasks' => '1.3.6.1.2.1.5.25',
  'icmpOutAddrMaskReps' => '1.3.6.1.2.1.5.26',
  'icmpStatsTable' => '1.3.6.1.2.1.5.29',
  'icmpStatsEntry' => '1.3.6.1.2.1.5.29.1',
  'icmpStatsIPVersion' => '1.3.6.1.2.1.5.29.1.1',
  'icmpStatsInMsgs' => '1.3.6.1.2.1.5.29.1.2',
  'icmpStatsInErrors' => '1.3.6.1.2.1.5.29.1.3',
  'icmpStatsOutMsgs' => '1.3.6.1.2.1.5.29.1.4',
  'icmpStatsOutErrors' => '1.3.6.1.2.1.5.29.1.5',
  'icmpMsgStatsTable' => '1.3.6.1.2.1.5.30',
  'icmpMsgStatsEntry' => '1.3.6.1.2.1.5.30.1',
  'icmpMsgStatsIPVersion' => '1.3.6.1.2.1.5.30.1.1',
  'icmpMsgStatsType' => '1.3.6.1.2.1.5.30.1.2',
  'icmpMsgStatsInPkts' => '1.3.6.1.2.1.5.30.1.3',
  'icmpMsgStatsOutPkts' => '1.3.6.1.2.1.5.30.1.4',
  'ipMIB' => '1.3.6.1.2.1.48',
  'ipMIBConformance' => '1.3.6.1.2.1.48.2',
  'ipMIBCompliances' => '1.3.6.1.2.1.48.2.1',
  'ipMIBGroups' => '1.3.6.1.2.1.48.2.2',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'IP-MIB'} = {
  'IpAddressStatusTC' => {
    '1' => 'preferred',
    '2' => 'deprecated',
    '3' => 'invalid',
    '4' => 'inaccessible',
    '5' => 'unknown',
    '6' => 'tentative',
    '7' => 'duplicate',
    '8' => 'optimistic',
  },
  'ipv6InterfaceForwarding' => {
    '1' => 'forwarding',
    '2' => 'notForwarding',
  },
  'ipNetToPhysicalType' => {
    '1' => 'other',
    '2' => 'invalid',
    '3' => 'dynamic',
    '4' => 'static',
    '5' => 'local',
  },
  'ipv6IpForwarding' => {
    '1' => 'forwarding',
    '2' => 'notForwarding',
  },
  'ipForwarding' => {
    '1' => 'forwarding',
    '2' => 'notForwarding',
  },
  'ipNetToMediaType' => {
    '1' => 'other',
    '2' => 'invalid',
    '3' => 'dynamic',
    '4' => 'static',
  },
  'ipDefaultRouterPreference' => {
    '0' => 'medium',
    '1' => 'high',
  },
  'ipv4InterfaceEnableStatus' => {
    '1' => 'up',
    '2' => 'down',
  },
  'IpAddressOriginTC' => {
    '1' => 'other',
    '2' => 'manual',
    '4' => 'dhcp',
    '5' => 'linklayer',
    '6' => 'random',
  },
  'ipAddressType' => {
    '1' => 'unicast',
    '2' => 'anycast',
    '3' => 'broadcast',
  },
  'ipNetToPhysicalState' => {
    '1' => 'reachable',
    '2' => 'stale',
    '3' => 'delay',
    '4' => 'probe',
    '5' => 'invalid',
    '6' => 'unknown',
    '7' => 'incomplete',
  },
  'ipv6InterfaceEnableStatus' => {
    '1' => 'up',
    '2' => 'down',
  },
  'IpAddressPrefixOriginTC' => {
    '1' => 'other',
    '2' => 'manual',
    '3' => 'wellknown',
    '4' => 'dhcp',
    '5' => 'routeradv',
  },
};
