<?php
// Copyright (C) <2015>  <it-novum GmbH>
//
// This file is dual licensed
//
// 1.
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, version 3 of the License.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// 2.
//  If you purchased an openITCOCKPIT Enterprise Edition you can use this file
//  under the terms of the openITCOCKPIT Enterprise Edition license agreement.
//  License agreement and license key will be shipped with the order
//  confirmation.

namespace App\Controller;

use App\Hoststatus;
use App\Servicestatus;


/**
 * StatusengineHoststatus Controller
 *
 * @property \App\Model\Table\StatusengineHoststatusTable $StatusengineHoststatus
 * @property \App\Model\Table\StatusengineServicestatusTable $StatusengineServicestatus
 */
class DashboardController extends AppController {

    public function initialize() {
        parent::initialize();
        $this->loadModel('StatusengineHoststatus');
        $this->loadModel('StatusengineServicestatus');
    }

    public function index() {
        if (!$this->isApiRequest()) {
            return;
        }

        $query = $this->StatusengineHoststatus->find('all');
        $hostCount = $query->count();

        $query = $this->StatusengineServicestatus->find('all');
        $serviceCount = $query->count();

        $hostSummaryStateQuery = $this->StatusengineHoststatus->find();
        $hostSummaryStateQuery->select([
            'current_state',
            'count' => $hostSummaryStateQuery->func()->count('*')
        ])
            ->group('current_state');

        $hostSummaryState = [
            'up'          => 0,
            'down'        => 0,
            'unreachable' => 0
        ];

        $Hoststatus = new Hoststatus();
        foreach ($hostSummaryStateQuery as $record) {
            $hostSummaryState[$Hoststatus->getStatenameByStateId($record->current_state)] = $record->count;
        }


        $serviceSummaryStateQuery = $this->StatusengineServicestatus->find();
        $serviceSummaryStateQuery->select([
            'current_state',
            'count' => $serviceSummaryStateQuery->func()->count('*')
        ])
            ->group('current_state');

        $serviceSummaryState = [
            'ok'       => 0,
            'warning'  => 0,
            'critical' => 0,
            'unknown'  => 0
        ];

        $Servicestatus = new Servicestatus();
        foreach ($serviceSummaryStateQuery as $record) {
            $serviceSummaryState[$Servicestatus->getStatenameByStateId($record->current_state)] = $record->count;
        }


        $this->set(compact(['hostCount', 'serviceCount', 'hostSummaryState', 'serviceSummaryState']));
        $this->set('_serialize', ['hostCount', 'serviceCount', 'hostSummaryState', 'serviceSummaryState']);

    }

    public function display() {
        $this->viewBuilder()->layout('main');
    }

}