<?php
/**
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link      http://cakephp.org CakePHP(tm) Project
 * @since     0.2.9
 * @license   http://www.opensource.org/licenses/mit-license.php MIT License
 */

namespace App\Controller;

use Cake\Core\Configure;
use Cake\Network\Exception\ForbiddenException;
use Cake\Network\Exception\NotFoundException;
use Cake\View\Exception\MissingTemplateException;
use Symfony\Component\Yaml\Yaml;

/**
 * Static content controller
 *
 * This controller will render views from Template/Pages/
 *
 * @link http://book.cakephp.org/3.0/en/controllers/pages-controller.html
 */
class PagesController extends AppController {

    public function configuration() {
        if (!$this->isApiRequest()) {
            $this->autoRender = false;
            return;
        }

        $configFile = CONFIG . 'interface.yml';
        $config = [];
        if (file_exists($configFile)) {
            $YamlParser = new Yaml();
            $config = $YamlParser->parse(file_get_contents($configFile));
        }

        $config['auth'] = $this->Auth->user();

        $this->set(compact('config'));
        $this->set('_serialize', ['config']);
    }

    public function paginator() {
        //Ship paginator HTML template
        return;
    }

}
