<?php

namespace App\Controller;

use App\Controller\AppController;
use App\Filter\HostStatehistoryFilter;

/**
 * StatusengineHostStatehistory Controller
 *
 * @property \App\Model\Table\StatusengineHostStatehistoryTable $StatusengineHostStatehistory
 */
class StatusengineHostStatehistoryController extends AppController {

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index() {
        if (!$this->isApiRequest()) {
            //Only ship the template for .html requests
            return;
        }

        $this->paginate = [
            'limit'         => 25,
            'order'         => [
                'StatusengineHostStatehistory.state_time' => 'desc'
            ],
        ];
        $HostStatehistoryFilter = new HostStatehistoryFilter($this->request);

        $query = $this->StatusengineHostStatehistory->find();
        $query->where($HostStatehistoryFilter->indexFilter());
        $hoststatehistory = $this->paginate($query);

        $this->set(compact('hoststatehistory', 'paging'));
        $this->set('_serialize', ['hoststatehistory', 'paging']);
    }

}
