<?php

namespace App\Controller;

use App\Controller\AppController;
use App\Filter\HostcheckFilter;

/**
 * StatusengineHostchecks Controller
 *
 * @property \App\Model\Table\StatusengineHostchecksTable $StatusengineHostchecks
 */
class StatusengineHostchecksController extends AppController {

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index() {
        if (!$this->isApiRequest()) {
            //Only ship the template for .html requests
            return;
        }

        $this->paginate = [
            'limit'         => 25,
            'order'         => [
                'StatusengineHostcheck.start_time' => 'desc'
            ],
            /*
            'sortWhitelist' => [
                'current_state',
                'active_checks_enabled',
                'last_state_change',
                'last_check',
                'next_check',
                'output',
                'Mapping.display_name',
            ]
            */
        ];
        $HostcheckFilter = new HostcheckFilter($this->request);

        $query = $this->StatusengineHostchecks->find();
        $query->where($HostcheckFilter->indexFilter());
        $hostchecks = $this->paginate($query);

        $this->set(compact('hostchecks', 'paging'));
        $this->set('_serialize', ['hostchecks', 'paging']);
    }

}
