<?php

namespace App\Controller;

use App\Controller\AppController;
use App\Filter\HoststatusFilter;
use App\Model\Entity\StatusengineHoststatus;
use App\Servicestatus;
use InvalidArgumentException;

/**
 * StatusengineHoststatus Controller
 *
 * @property \App\Model\Table\StatusengineHoststatusTable $StatusengineHoststatus
 */
class StatusengineHoststatusController extends AppController {

    public function initialize() {
        parent::initialize();
        $this->loadModel('StatusengineHoststatus');
        $this->loadModel('StatusengineServicestatus');
    }

    public function index() {
        if (!$this->isApiRequest()) {
            //Only ship the template for .html requests
            return;
        }

        $this->paginate = [
            'limit'         => 25,
            'order'         => [
                'StatusengineHoststatus.hostname' => 'asc'
            ],
            'contain'       => [
                'Mapping'
            ],
            'sortWhitelist' => [
                'current_state',
                'active_checks_enabled',
                'last_state_change',
                'last_check',
                'next_check',
                'output',
                'Mapping.display_name',
            ]
        ];

        $query = $this->StatusengineHoststatus->find();

        $HoststatusFilter = new HoststatusFilter($this->request);

        $query->where($HoststatusFilter->indexFilter());
        $hoststatus = $this->paginate($query);
        $hoststatus = $hoststatus->toArray();
        /**
         * @var StatusengineHoststatus $host
         */
        foreach ($hoststatus as $key => $host) {
            $serviceSummaryStateQuery = $this->StatusengineServicestatus->find();
            $serviceSummaryStateQuery->select([
                'current_state',
                'count' => $serviceSummaryStateQuery->func()->count('*')
            ])
                ->where(['hostname' => $host->hostname])
                ->group('current_state');

            $serviceSummaryState = [
                'ok'       => 0,
                'warning'  => 0,
                'critical' => 0,
                'unknown'  => 0
            ];
            $Servicestatus = new Servicestatus();
            foreach ($serviceSummaryStateQuery as $record) {
                $serviceSummaryState[$Servicestatus->getStatenameByStateId($record->current_state)] = $record->count;
            }
            $hoststatus[$key]['servicestatus_summary'] = $serviceSummaryState;

        }


        $this->set(compact('hoststatus', 'paging'));
        $this->set('_serialize', ['hoststatus', 'paging']);
    }

    public function details() {
        if (!$this->isApiRequest()) {
            //Ship host details HTML template
            return;
        }

        if(!isset($this->request->query['uuid'])){
            throw new InvalidArgumentException('Query Parameter &uuid= is missing!');
        }
        $uuid = $this->request->query['uuid'];

        $hoststatus = $this->StatusengineHoststatus->find('all', [
            'fields' => [
                'StatusengineHoststatus.hostname',
                'StatusengineHoststatus.current_state',
                'StatusengineHoststatus.active_checks_enabled',
                'StatusengineHoststatus.last_state_change',
                'StatusengineHoststatus.last_check',
                'StatusengineHoststatus.next_check',
                'StatusengineHoststatus.normal_check_interval',
                'StatusengineHoststatus.retry_check_interval',
                'StatusengineHoststatus.output',
                'StatusengineHoststatus.flap_detection_enabled',
                'StatusengineHoststatus.is_flapping',
                'StatusengineHoststatus.current_check_attempt',
                'StatusengineHoststatus.max_check_attempts',
                'StatusengineHoststatus.long_output',
                'StatusengineHoststatus.is_hardstate',
                'MappingTimeperiod.display_name',
                'Mapping.display_name'
            ]
        ])
            ->contain('Mapping')
            ->where(['StatusengineHoststatus.hostname' => $uuid])
            ->hydrate(false)
            ->join([
                'MappingTimeperiod'         => [
                    'table'      => 'mapping',
                    'alias'      => 'MappingTimeperiod',
                    'type'       => 'INNER',
                    'foreignKey' => false,
                    'conditions' =>
                        'MappingTimeperiod.uuid = StatusengineHoststatus.check_timeperiod'

                ]
            ])->first();

        $this->set(compact('hoststatus'));
        $this->set('_serialize', ['hoststatus']);
    }

    public function icon() {
        //Ship status icon HTML template
        return;
    }

    public function menu() {

    }

    public function hoststatusdetailsmodal(){
        //Ship modal HTML template
        return;
    }

}

