<?php

namespace App\Controller;

use App\Controller\AppController;
use App\Filter\ServiceStatehistoryFilter;

/**
 * StatusengineHostStatehistory Controller
 *
 * @property \App\Model\Table\StatusengineServiceStatehistoryTable $StatusengineServiceStatehistory
 */
class StatusengineServiceStatehistoryController extends AppController {

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index() {
        if (!$this->isApiRequest()) {
            //Only ship the template for .html requests
            return;
        }

        $this->paginate = [
            'limit'         => 25,
            'order'         => [
                'StatusengineServiceStatehistory.state_time' => 'desc'
            ],
        ];
        $ServiceStatehistoryFilter = new ServiceStatehistoryFilter($this->request);

        $query = $this->StatusengineServiceStatehistory->find();
        $query->where($ServiceStatehistoryFilter->indexFilter());
        $servicestatehistory = $this->paginate($query);

        $this->set(compact('servicestatehistory', 'paging'));
        $this->set('_serialize', ['servicestatehistory', 'paging']);
    }

}
