<?php

namespace App\Controller;

use App\Controller\AppController;
use App\Filter\ServicecheckFilter;

/**
 * StatusengineServicechecks Controller
 *
 * @property \App\Model\Table\StatusengineServicechecksTable $StatusengineServicechecks
 */
class StatusengineServicechecksController extends AppController {

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index() {
        if (!$this->isApiRequest()) {
            //Only ship the template for .html requests
            return;
        }

        $this->paginate = [
            'limit'         => 25,
            'order'         => [
                'StatusengineServicecheck.start_time' => 'desc'
            ],
        ];
        $ServicecheckFilter = new ServicecheckFilter($this->request);

        $query = $this->StatusengineServicechecks->find();
        $query->where($ServicecheckFilter->indexFilter());
        $servicechecks = $this->paginate($query);

        $this->set(compact('servicechecks', 'paging'));
        $this->set('_serialize', ['servicechecks', 'paging']);
    }
}
