<?php

namespace App\Controller;

use App\Controller\AppController;
use App\Filter\ServicestatusFilter;
use Cake\Utility\Hash;
use InvalidArgumentException;

/**
 * StatusengineHoststatus Controller
 *
 * @property \App\Model\Table\StatusengineServicestatusTable $StatusengineServicestatus
 *  * @property \App\Model\Table\StatusengineHoststatusTable $StatusengineHoststatus
 */
class StatusengineServicestatusController extends AppController {

    public function initialize() {
        parent::initialize();
        $this->loadModel('StatusengineHoststatus');
        $this->loadModel('StatusengineServicestatus');
    }

    public function index() {
        if (!$this->isApiRequest()) {
            //Only ship the template for .html requests
            return;
        }

        $this->paginate = [
            'limit'         => 25,
            'order'         => [
                'StatusengineServicestatus.service_description' => 'asc'
            ],
            'contain'       => [
                'Mapping'
            ],
            'sortWhitelist' => [
                'current_state',
                'active_checks_enabled',
                'last_state_change',
                'last_check',
                'next_check',
                'output',
                'MappingHost.display_name',
                'MappingService.display_name'
            ]
        ];


        $query = $this->StatusengineServicestatus->find('all', [
            'fields' => [
                'StatusengineServicestatus.hostname',
                'StatusengineServicestatus.service_description',
                'StatusengineServicestatus.current_state',
                'StatusengineServicestatus.active_checks_enabled',
                'StatusengineServicestatus.last_state_change',
                'StatusengineServicestatus.last_check',
                'StatusengineServicestatus.next_check',
                'StatusengineServicestatus.output',
                'MappingHost.display_name',
                'MappingService.display_name',
                'StatusengineHoststatus.current_state'
            ]
        ])
            ->hydrate(false)
            ->join([
                'MappingService'         => [
                    'table'      => 'mapping',
                    'alias'      => 'MappingService',
                    'type'       => 'INNER',
                    'foreignKey' => false,
                    'conditions' =>
                        'MappingService.uuid = StatusengineServicestatus.service_description'

                ],
                'MappingHost'            => [
                    'table'      => 'mapping',
                    'alias'      => 'MappingHost',
                    'foreignKey' => false,
                    'type'       => 'INNER',
                    'conditions' => 'MappingHost.uuid = StatusengineServicestatus.hostname'

                ],
                'StatusengineHoststatus' => [
                    'table'      => $this->StatusengineHoststatus->table(),
                    'alias'      => 'StatusengineHoststatus',
                    'foreignKey' => false,
                    'type'       => 'INNER',
                    'conditions' => 'StatusengineHoststatus.hostname = StatusengineServicestatus.hostname'

                ]
            ]);


        $ServicestatusFilter = new ServicestatusFilter($this->request);


        $query->where($ServicestatusFilter->indexFilter());
        $servicestatus = $this->paginate($query);
        $servicestatus = $servicestatus->toArray();

        $this->set(compact('servicestatus', 'paging'));
        $this->set('_serialize', ['servicestatus', 'paging']);
    }

    public function details() {
        if (!$this->isApiRequest()) {
            //Ship host details HTML template
            return;
        }

        if (!isset($this->request->query['serviceuuid'])) {
            throw new InvalidArgumentException('Query Parameter &serviceuuid= is missing!');
        }
        $uuid = $this->request->query['serviceuuid'];

        $servicestatus = $this->StatusengineServicestatus->find('all', [
            'fields' => [
                'StatusengineServicestatus.hostname',
                'StatusengineServicestatus.service_description',
                'StatusengineServicestatus.current_state',
                'StatusengineServicestatus.active_checks_enabled',
                'StatusengineServicestatus.last_state_change',
                'StatusengineServicestatus.last_check',
                'StatusengineServicestatus.next_check',
                'StatusengineServicestatus.output',
                'StatusengineServicestatus.flap_detection_enabled',
                'StatusengineServicestatus.is_flapping',
                'StatusengineServicestatus.current_check_attempt',
                'StatusengineServicestatus.max_check_attempts',
                'StatusengineServicestatus.long_output',
                'StatusengineServicestatus.is_hardstate',
                'StatusengineServicestatus.normal_check_interval',
                'StatusengineServicestatus.retry_check_interval',
                'MappingTimeperiod.display_name',
                'Mapping.display_name'
            ]
        ])
            ->contain('Mapping')
            ->where(['StatusengineServicestatus.service_description' => $uuid])
            ->hydrate(false)
            ->join([
                'MappingTimeperiod' => [
                    'table'      => 'mapping',
                    'alias'      => 'MappingTimeperiod',
                    'type'       => 'INNER',
                    'foreignKey' => false,
                    'conditions' =>
                        'MappingTimeperiod.uuid = StatusengineServicestatus.check_timeperiod'

                ]
            ])->first();

        $this->set(compact('servicestatus'));
        $this->set('_serialize', ['servicestatus']);
    }

    public function automap() {
        if (!$this->isApiRequest()) {
            //Only ship HTML template
            return;
        }

        $query = $this->StatusengineServicestatus->find('all', [
            'fields' => [
                'StatusengineServicestatus.hostname',
                'StatusengineServicestatus.service_description',
                'StatusengineServicestatus.current_state',
                'StatusengineServicestatus.active_checks_enabled',
                'StatusengineServicestatus.last_state_change',
                'StatusengineServicestatus.last_check',
                'StatusengineServicestatus.next_check',
                'StatusengineServicestatus.output',
                'MappingHost.display_name',
                'MappingService.display_name',
                'StatusengineHoststatus.current_state'
            ]
        ])
            ->hydrate(false)
            ->join([
                'MappingService'         => [
                    'table'      => 'mapping',
                    'alias'      => 'MappingService',
                    'type'       => 'INNER',
                    'foreignKey' => false,
                    'conditions' =>
                        'MappingService.uuid = StatusengineServicestatus.service_description'

                ],
                'MappingHost'            => [
                    'table'      => 'mapping',
                    'alias'      => 'MappingHost',
                    'foreignKey' => false,
                    'type'       => 'INNER',
                    'conditions' => 'MappingHost.uuid = StatusengineServicestatus.hostname'

                ],
                'StatusengineHoststatus' => [
                    'table'      => $this->StatusengineHoststatus->table(),
                    'alias'      => 'StatusengineHoststatus',
                    'foreignKey' => false,
                    'type'       => 'INNER',
                    'conditions' => 'StatusengineHoststatus.hostname = StatusengineServicestatus.hostname'

                ]
            ]);


        $ServicestatusFilter = new ServicestatusFilter($this->request);


        $query->where($ServicestatusFilter->indexFilter());
        $query->order([
            'MappingHost.display_name'    => 'asc',
            'MappingService.display_name' => 'asc'
        ]);
        $servicestatus = $query->toArray();

        $services = [];
        foreach ($servicestatus as $record) {
            if (!isset($services[$record['hostname']])) {
                $services[$record['hostname']] = [
                    'hoststatus'   => [
                        'current_state' => $record['StatusengineHoststatus']['current_state']
                    ],
                    'display_name' => $record['MappingHost']['display_name'],
                    'hostname'     => $record['hostname']
                ];
                $services[$record['hostname']]['servicestatus'] = [];
            }
            $services[$record['hostname']]['servicestatus'][] = $record;
        }

        $this->set(compact('services'));
        $this->set('_serialize', ['services']);

    }

    public function icon() {
        //Ship service status icon HTML template
        return;
    }

    public function menu() {
        //Ship service menu HTML template
        return;
    }


    public function servicestatusdetailsmodal(){
        //Ship modal HTML template
        return;
    }

}

