<?php

namespace App\Controller;

use App\Controller\AppController;
use App\Filter\UserFilter;

/**
 * Users Controller
 *
 * @property \App\Model\Table\UsersTable $Users
 */
class UsersController extends AppController {

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index() {
        if (!$this->isApiRequest()) {
            //Only ship the template for .html requests
            return;
        }

        $this->paginate = [
            'limit' => 25,
            'order' => [
                'Users.username' => 'asc'
            ],
        ];

        $UserFilter = new UserFilter($this->request);
        $query = $this->Users->find();
        $query->where($UserFilter->indexFilter());

        $users = $this->paginate($query);

        $this->set(compact('users', 'paging'));
        $this->set('_serialize', ['users', 'paging']);
    }

    /**
     * View method
     *
     * @param string|null $id User id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null) {
        $user = $this->Users->get($id, [
            'contain' => []
        ]);

        $this->set('user', $user);
        $this->set('_serialize', ['user']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add() {
        $user = $this->Users->newEntity();
        if ($this->request->is('post')) {
            $user = $this->Users->patchEntity($user, $this->request->data);

            if ($this->Users->save($user)) {
                $this->set('id', $user->id);
                $this->set('_serialize', ['id']);
                return;
            }
            $validationErrors = $user->errors();
            $this->set('validationErrors', $validationErrors);
            $this->response->statusCode(400);
        }


        $this->set(compact('user'));
        $this->set('_serialize', ['user', 'validationErrors']);
    }

    /**
     * Edit method
     *
     * @param string|null $id User id.
     * @return \Cake\Network\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null) {
        $user = $this->Users->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $user = $this->Users->patchEntity($user, $this->request->data);
            if (!$this->Users->save($user)) {
                $validationErrors = $user->errors();
                $this->set('validationErrors', $validationErrors);
                $this->response->statusCode(400);
            }
        }
        $this->set(compact('user'));
        $this->set('_serialize', ['user', 'validationErrors']);
    }

    /**
     * Delete method
     *
     * @param string|null $id User id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null) {
        $this->autoRender = false;
        $this->request->allowMethod(['post', 'delete']);
        $user = $this->Users->get($id);
        if (!$this->Users->delete($user)) {
            $this->response->statusCode(400);
        }
    }

    public function login(){
        $this->viewBuilder()->layout('login');
        if ($this->request->is('post')) {
            $user = $this->Auth->identify();
            if ($user) {
                $this->Auth->setUser($user);
                return $this->redirect('/');
            } else {
                $this->Flash->error(__('Username or password is incorrect'));
            }
        }
    }

    public function logout(){
        return $this->redirect($this->Auth->logout());
    }
}
