<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Mapping Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Types
 *
 * @method \App\Model\Entity\Mapping get($primaryKey, $options = [])
 * @method \App\Model\Entity\Mapping newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Mapping[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Mapping|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Mapping patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Mapping[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Mapping findOrCreate($search, callable $callback = null, $options = [])
 */
class MappingTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('mapping');
        $this->displayField('id');
        $this->primaryKey('id');

    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('uuid', 'create')
            ->notEmpty('uuid');

        $validator
            ->requirePresence('display_name', 'create')
            ->notEmpty('display_name');

        return $validator;
    }

}
