<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * StatusengineHostStatehistory Model
 *
 * @method \App\Model\Entity\StatusengineHostStatehistory get($primaryKey, $options = [])
 * @method \App\Model\Entity\StatusengineHostStatehistory newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\StatusengineHostStatehistory[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\StatusengineHostStatehistory|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\StatusengineHostStatehistory patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\StatusengineHostStatehistory[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\StatusengineHostStatehistory findOrCreate($search, callable $callback = null, $options = [])
 */
class StatusengineHostStatehistoryTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('statusengine_host_statehistory');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->allowEmpty('hostname');

        $validator
            ->requirePresence('state_time', 'create')
            ->notEmpty('state_time');

        $validator
            ->boolean('state_change')
            ->allowEmpty('state_change');

        $validator
            ->boolean('state')
            ->allowEmpty('state');

        $validator
            ->boolean('is_hardstate')
            ->allowEmpty('is_hardstate');

        $validator
            ->integer('current_check_attempt')
            ->allowEmpty('current_check_attempt');

        $validator
            ->integer('max_check_attempts')
            ->allowEmpty('max_check_attempts');

        $validator
            ->boolean('last_state')
            ->allowEmpty('last_state');

        $validator
            ->boolean('last_hard_state')
            ->allowEmpty('last_hard_state');

        $validator
            ->allowEmpty('output');

        $validator
            ->allowEmpty('long_output');

        return $validator;
    }
}
