<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * StatusengineHoststatus Model
 *
 * @method \App\Model\Entity\StatusengineHoststatus get($primaryKey, $options = [])
 * @method \App\Model\Entity\StatusengineHoststatus newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\StatusengineHoststatus[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\StatusengineHoststatus|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\StatusengineHoststatus patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\StatusengineHoststatus[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\StatusengineHoststatus findOrCreate($search, callable $callback = null, $options = [])
 */
class StatusengineHoststatusTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('statusengine_hoststatus');
        $this->displayField('hostname');
        $this->primaryKey('hostname');

        $this->hasOne('Mapping', [
            'className' => 'Mapping',
            'foreignKey' => 'uuid',
            'joinType' => 'INNER'
        ]);

    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->allowEmpty('hostname', 'create');

        $validator
            ->requirePresence('status_update_time', 'create')
            ->notEmpty('status_update_time');

        $validator
            ->allowEmpty('output');

        $validator
            ->allowEmpty('long_output');

        $validator
            ->allowEmpty('perfdata');

        $validator
            ->numeric('current_state')
            ->allowEmpty('current_state');

        $validator
            ->boolean('current_check_attempt')
            ->allowEmpty('current_check_attempt');

        $validator
            ->boolean('max_check_attempts')
            ->allowEmpty('max_check_attempts');

        $validator
            ->requirePresence('last_check', 'create')
            ->notEmpty('last_check');

        $validator
            ->requirePresence('next_check', 'create')
            ->notEmpty('next_check');

        $validator
            ->boolean('is_passive_check')
            ->allowEmpty('is_passive_check');

        $validator
            ->requirePresence('last_state_change', 'create')
            ->notEmpty('last_state_change');

        $validator
            ->requirePresence('last_hard_state_change', 'create')
            ->notEmpty('last_hard_state_change');

        $validator
            ->boolean('last_hard_state')
            ->allowEmpty('last_hard_state');

        $validator
            ->boolean('is_hardstate')
            ->allowEmpty('is_hardstate');

        $validator
            ->requirePresence('last_notification', 'create')
            ->notEmpty('last_notification');

        $validator
            ->requirePresence('next_notification', 'create')
            ->notEmpty('next_notification');

        $validator
            ->boolean('notifications_enabled')
            ->allowEmpty('notifications_enabled');

        $validator
            ->boolean('problem_has_been_acknowledged')
            ->allowEmpty('problem_has_been_acknowledged');

        $validator
            ->boolean('acknowledgement_type')
            ->allowEmpty('acknowledgement_type');

        $validator
            ->boolean('passive_checks_enabled')
            ->allowEmpty('passive_checks_enabled');

        $validator
            ->boolean('active_checks_enabled')
            ->allowEmpty('active_checks_enabled');

        $validator
            ->boolean('event_handler_enabled')
            ->allowEmpty('event_handler_enabled');

        $validator
            ->boolean('flap_detection_enabled')
            ->allowEmpty('flap_detection_enabled');

        $validator
            ->boolean('is_flapping')
            ->allowEmpty('is_flapping');

        $validator
            ->numeric('latency')
            ->allowEmpty('latency');

        $validator
            ->numeric('execution_time')
            ->allowEmpty('execution_time');

        $validator
            ->boolean('scheduled_downtime_depth')
            ->allowEmpty('scheduled_downtime_depth');

        $validator
            ->boolean('process_performance_data')
            ->allowEmpty('process_performance_data');

        $validator
            ->boolean('obsess_over_host')
            ->allowEmpty('obsess_over_host');

        $validator
            ->integer('normal_check_interval')
            ->allowEmpty('normal_check_interval');

        $validator
            ->integer('retry_check_interval')
            ->allowEmpty('retry_check_interval');

        $validator
            ->allowEmpty('check_timeperiod');

        $validator
            ->allowEmpty('node_name');

        $validator
            ->requirePresence('last_time_up', 'create')
            ->notEmpty('last_time_up');

        $validator
            ->requirePresence('last_time_down', 'create')
            ->notEmpty('last_time_down');

        $validator
            ->requirePresence('last_time_unreachable', 'create')
            ->notEmpty('last_time_unreachable');

        $validator
            ->integer('current_notification_number')
            ->allowEmpty('current_notification_number');

        $validator
            ->numeric('percent_state_change')
            ->allowEmpty('percent_state_change');

        $validator
            ->allowEmpty('event_handler');

        $validator
            ->allowEmpty('check_command');

        return $validator;
    }
}
