<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * StatusengineServiceStatehistory Model
 *
 * @method \App\Model\Entity\StatusengineServiceStatehistory get($primaryKey, $options = [])
 * @method \App\Model\Entity\StatusengineServiceStatehistory newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\StatusengineServiceStatehistory[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\StatusengineServiceStatehistory|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\StatusengineServiceStatehistory patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\StatusengineServiceStatehistory[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\StatusengineServiceStatehistory findOrCreate($search, callable $callback = null, $options = [])
 */
class StatusengineServiceStatehistoryTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('statusengine_service_statehistory');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->allowEmpty('hostname');

        $validator
            ->allowEmpty('service_description');

        $validator
            ->requirePresence('state_time', 'create')
            ->notEmpty('state_time');

        $validator
            ->boolean('state_change')
            ->allowEmpty('state_change');

        $validator
            ->integer('state')
            ->allowEmpty('state');

        $validator
            ->boolean('is_hardstate')
            ->allowEmpty('is_hardstate');

        $validator
            ->integer('current_check_attempt')
            ->allowEmpty('current_check_attempt');

        $validator
            ->integer('max_check_attempts')
            ->allowEmpty('max_check_attempts');

        $validator
            ->integer('last_state')
            ->allowEmpty('last_state');

        $validator
            ->integer('last_hard_state')
            ->allowEmpty('last_hard_state');

        $validator
            ->allowEmpty('output');

        $validator
            ->allowEmpty('long_output');

        return $validator;
    }
}
