<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * StatusengineServicechecks Model
 *
 * @method \App\Model\Entity\StatusengineServicecheck get($primaryKey, $options = [])
 * @method \App\Model\Entity\StatusengineServicecheck newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\StatusengineServicecheck[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\StatusengineServicecheck|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\StatusengineServicecheck patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\StatusengineServicecheck[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\StatusengineServicecheck findOrCreate($search, callable $callback = null, $options = [])
 */
class StatusengineServicechecksTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('statusengine_servicechecks');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->allowEmpty('hostname');

        $validator
            ->allowEmpty('service_description');

        $validator
            ->boolean('state')
            ->allowEmpty('state');

        $validator
            ->boolean('is_hardstate')
            ->allowEmpty('is_hardstate');

        $validator
            ->requirePresence('start_time', 'create')
            ->notEmpty('start_time');

        $validator
            ->requirePresence('end_time', 'create')
            ->notEmpty('end_time');

        $validator
            ->allowEmpty('output');

        $validator
            ->integer('timeout')
            ->allowEmpty('timeout');

        $validator
            ->boolean('early_timeout')
            ->allowEmpty('early_timeout');

        $validator
            ->numeric('latency')
            ->allowEmpty('latency');

        $validator
            ->numeric('execution_time')
            ->allowEmpty('execution_time');

        $validator
            ->allowEmpty('perfdata');

        $validator
            ->allowEmpty('command');

        $validator
            ->integer('current_check_attempt')
            ->allowEmpty('current_check_attempt');

        $validator
            ->integer('max_check_attempts')
            ->allowEmpty('max_check_attempts');

        $validator
            ->allowEmpty('long_output');

        return $validator;
    }
}
