<?php

namespace App\Shell;

use Cake\Console\Shell;
use RuntimeException;
use Symfony\Component\Yaml\Yaml;

/**
 * MappingImport shell command.
 * @property \App\Model\Table\MappingTable $Mapping
 */
class MappingImportShell extends Shell {

    /**
     * Manage the available sub-commands along with their arguments and help
     *
     * @see http://book.cakephp.org/3.0/en/console-and-shells.html#configuring-options-and-generating-help
     *
     * @return \Cake\Console\ConsoleOptionParser
     */
    public function getOptionParser() {
        $parser = parent::getOptionParser();

        return $parser;
    }

    public function initialize() {
        parent::initialize();
        $this->loadModel('Mapping');
    }

    /**
     * main() method.
     *
     * @return bool|int|null Success or error code.
     */
    public function main() {
        $configFile = CONFIG . 'interface.yml';
        $config = [];
        if (!file_exists($configFile)) {
            throw new RuntimeException(sprintf('Configuration file %s is missing!', $configFile));
        }

        $YamlParser = new Yaml();
        $config = $YamlParser->parse(file_get_contents($configFile));

        if (!isset($config['mapping_file']) || !file_exists($config['mapping_file'])) {
            throw new RuntimeException(sprintf('Mapping file %s not found!', $config['mapping_file']));
        }

        $sqlStatements = $this->Mapping->schema()->truncateSql($this->Mapping->connection());
        foreach($sqlStatements as $sqlStatement){
            $this->Mapping->connection()->execute($sqlStatement)->execute();
        }

        $data = file_get_contents($config['mapping_file']);
        $data = json_decode($data, true);


        foreach ($data as $objectType => $objects) {
            foreach ($objects as $uuid => $displayName) {
                $data = [
                    'Mapping' => [
                        'uuid' => $uuid,
                        'display_name' => $displayName,
                        'type_id' => $objectType
                    ]
                ];
                $mapping = $this->Mapping->newEntity();
                $mapping = $this->Mapping->patchEntity($mapping, $data);
                $this->Mapping->save($mapping);
            }
        }

    }
}
