<?php

namespace App\Shell;

use Cake\Cache\Cache;
use Cake\Console\Shell;

/**
 * User shell command.
 *
 * @property \App\Model\Table\UsersTable $Users
 */
class UserShell extends Shell {

    public function initialize() {
        Cache::disable();
        Cache::clear();
        $this->loadModel('Users');
        parent::initialize();
    }

    /**
     * Manage the available sub-commands along with their arguments and help
     *
     * @see http://book.cakephp.org/3.0/en/console-and-shells.html#configuring-options-and-generating-help
     *
     * @return \Cake\Console\ConsoleOptionParser
     */
    public function getOptionParser() {
        $parser = parent::getOptionParser();
        $parser->description('Create a new Interface user');
        $parser->addOption('username', [
            'help' => 'The username you want to create'
        ]);

        $parser->addOption('password', [
            'help' => 'The password for the user you want to create'
        ]);

        return $parser;
    }

    /**
     * main() method.
     *
     * @return bool|int|null Success or error code.
     */
    public function main() {
        if(isset($this->params['username']) && isset($this->params['password'])){
            $username = $this->params['username'];
            $password = $this->params['password'];
        }else {
            $username = $this->askUsername();
            $password = $this->askPassword();
            $passwordConfirm = $this->askPasswordConfirm();

            if($password !== $passwordConfirm){
                $this->err('Password missmatch!');
                exit(1);
            }
        }

        $user = $this->Users->newEntity();
        $user->username = $username;
        $user->password = $password;

        if ($this->Users->save($user)) {
            $this->out('<success>User created successfully</success>');
            exit(0);
        }

        $this->err('Error while creating user');
        print_r($user->errors());
        exit(1);
    }

    /**
     * @return string
     */
    private function askUsername() {
        do {
            $username = trim($this->in('Please enter the username.'));
        } while (empty($username));
        return $username;
    }

    /**
     * @return string
     */
    private function askPassword() {
        do {
            $password = trim($this->in('Please enter your password.'));
        } while (empty($password));
        return $password;
    }

    /**
     * @return string
     */
    private function askPasswordConfirm() {
        do {
            $password = trim($this->in('Please confirm your password.'));
        } while (empty($password));
        return $password;
    }
}
