<?php
// Copyright (C) <2015>  <it-novum GmbH>
//
// This file is dual licensed
//
// 1.
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, version 3 of the License.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// 2.
//  If you purchased an openITCOCKPIT Enterprise Edition you can use this file
//  under the terms of the openITCOCKPIT Enterprise Edition license agreement.
//  License agreement and license key will be shipped with the order
//  confirmation.
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-xs-12 col-sm-7 col-md-7 col-lg-4">
            <h1 class="page-title txt-color-blueDark">
                <i class="fa fa-dashboard fa-fw "></i>
                <?php echo __('Dashboard'); ?>
            </h1>
        </div>
    </div>
</div>

<div class="jarviswidget">

    <header role="heading">

        <h2><strong><?php echo __('Dashboard'); ?></strong> <i><?php echo __('Status Overview'); ?></i></h2>
    </header>

    <div role="content">
        <div class="widget-body">
            <div class="container-fluid">
                <div class="row margin-top-5">
                    <div class="col-lg-3 col-xs-6">
                        <div class="small-box bg-aqua">
                            <div class="inner">
                                <h3>{{ dashboardData.hostCount }}</h3>

                                <p><?php echo __('Total Hosts'); ?></p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-desktop"></i>
                            </div>
                            <a ui-sref="hosts" class="small-box-footer">
                                <?php echo __('View'); ?> <i class="fa fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-2 col-xs-6">
                        <div class="small-box bg-green">
                            <div class="inner">
                                <h3>{{ dashboardData.hostSummaryState.up }}</h3>

                                <p><?php echo __('Hosts Up'); ?></p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-check"></i>
                            </div>
                            <a ui-sref="hosts({'statename':'up'})" class="small-box-footer">
                                <?php echo __('View'); ?> <i class="fa fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-2 col-xs-6">
                        <div class="small-box bg-red">
                            <div class="inner">
                                <h3>{{ dashboardData.hostSummaryState.down }}</h3>

                                <p><?php echo __('Hosts Down'); ?></p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-exclamation-triangle"></i>
                            </div>
                            <a ui-sref="hosts({'statename':'down'})" class="small-box-footer">
                                <?php echo __('View'); ?> <i class="fa fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-2 col-xs-6">
                        <div class="small-box bg-gray">
                            <div class="inner">
                                <h3>{{ dashboardData.hostSummaryState.unreachable }}</h3>

                                <p><?php echo __('Hosts Unreachable'); ?></p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-question-circle"></i>
                            </div>
                            <a ui-sref="hosts({'statename':'unreachable'})" class="small-box-footer">
                                <?php echo __('View'); ?> <i class="fa fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>
                </div>


                <div class="row margin-top-5">
                    <div class="col-lg-3 col-xs-6">
                        <div class="small-box bg-light-blue">
                            <div class="inner">
                                <h3>{{ dashboardData.serviceCount }}</h3>

                                <p><?php echo __('Total Service'); ?></p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-cogs"></i>
                            </div>
                            <a ui-sref="services" class="small-box-footer">
                                <?php echo __('View'); ?> <i class="fa fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-2 col-xs-6">
                        <div class="small-box bg-green">
                            <div class="inner">
                                <h3>{{ dashboardData.serviceSummaryState.ok }}</h3>

                                <p><?php echo __('Total Service'); ?></p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-check"></i>
                            </div>
                            <a ui-sref="services({'statename':'ok'})" class="small-box-footer">
                                <?php echo __('View'); ?> <i class="fa fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-2 col-xs-6">
                        <div class="small-box bg-orange">
                            <div class="inner">
                                <h3>{{ dashboardData.serviceSummaryState.warning }}</h3>

                                <p><?php echo __('Total Service'); ?></p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-exclamation-triangle"></i>
                            </div>
                            <a ui-sref="services({'statename':'warning'})" class="small-box-footer">
                                <?php echo __('View'); ?> <i class="fa fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-2 col-xs-6">
                        <div class="small-box bg-red">
                            <div class="inner">
                                <h3>{{ dashboardData.serviceSummaryState.critical }}</h3>

                                <p><?php echo __('Total Service'); ?></p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-exclamation-triangle"></i>
                            </div>
                            <a ui-sref="services({'statename':'critical'})" class="small-box-footer">
                                <?php echo __('View'); ?> <i class="fa fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-2 col-xs-6">
                        <div class="small-box bg-gray">
                            <div class="inner">
                                <h3>{{ dashboardData.serviceSummaryState.unknown }}</h3>

                                <p><?php echo __('Total Service'); ?></p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-question-circle"></i>
                            </div>
                            <a ui-sref="services({'statename':'unknown'})" class="small-box-footer">
                                <?php echo __('View'); ?> <i class="fa fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </div>
</div>