<?php

use Cake\Routing\Router;

$styles = [
    'vendor/bootstrap/dist/css/bootstrap.min.css',
    'vendor/font-awesome/css/font-awesome.min.css',
    'css/SmartAdmin/smartadmin-production.css',
    'css/SmartAdmin/smartadmin-production-plugins.css',
    'css/app.css',
];

$scripts = [
    'vendor/jquery/dist/jquery.min.js',
    'vendor/jqueryui/jquery-ui.min.js',
    'js/SmartAdmin/app.config.js',
    'vendor/bootstrap/dist/js/bootstrap.min.js',
];


?>

<!DOCTYPE html>
<html ng-app="openITCOCKPIT">
<head>
    <?php echo $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
        <?php echo $this->fetch('title') ?>
    </title>
    <?php
    echo $this->Html->meta('icon');

    foreach ($styles as $style):
        printf('<link rel="stylesheet" href="%s/%s"/>', Router::fullBaseUrl(), $style);
    endforeach;

    foreach ($scripts as $script):
        printf('<script src="%s/%s"></script>', Router::fullBaseUrl(), $script);
    endforeach;
    ?>


    <?php echo $this->fetch('meta') ?>
</head>

<body class="smart-style-0">
<div class="wrapper">

    <header id="header">
        <div id="logo-group">
            <span id="logo"></span>
        </div>
    </header>

    <div class="container" id="main-container">
        <div class="row">
            <div class="col-md-12 controller Login_login">
                <?php echo $this->Flash->render() ?>
                <div id="content">
                    <?php echo $this->fetch('content'); ?>
                </div>
            </div>
        </div>
    </div>


</div>


</body>
</html>

