<?php

use Cake\Filesystem\Folder;
use Cake\Routing\Router;
use Symfony\Component\Filesystem\Filesystem;

$styles = [
    'vendor/bootstrap/dist/css/bootstrap.min.css',
    'vendor/font-awesome/css/font-awesome.min.css',
    'css/SmartAdmin/smartadmin-production.css',
    'css/SmartAdmin/smartadmin-production-plugins.css',
    'css/app.css',
    'css/adminlte.css',
    'vendor/noty/lib/noty.css'
];

$scripts = [
    'vendor/jquery/dist/jquery.min.js',
    'vendor/jqueryui/jquery-ui.min.js',
    'js/SmartAdmin/app.config.js',
    'vendor/bootstrap/dist/js/bootstrap.min.js',
    'js/SmartAdmin/app.js',
    'js/SmartAdmin/smartwidgets/jarvis.widget.js',
    'vendor/angular/angular.min.js',
    'vendor/angular-ui-router/release/angular-ui-router.min.js',
    'vendor/angular-bootstrap/ui-bootstrap.min.js',
    'vendor/angular-bootstrap/ui-bootstrap-tpls.min.js',
    'vendor/noty/lib/noty.min.js'
];


$ScriptsFolder = new Folder(WWW_ROOT . 'js' . DS . 'scripts' . DS);
$appScripts = $ScriptsFolder->findRecursive('.*\.js');

?>

<!DOCTYPE html>
<html ng-app="openITCOCKPIT">
<head>
    <?php echo $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
        <?php echo $this->fetch('title') ?>
    </title>
    <?php
    echo $this->Html->meta('icon');

    foreach ($styles as $style):
        printf('<link rel="stylesheet" href="%s/%s"/>', Router::fullBaseUrl(), $style);
    endforeach;

    foreach ($scripts as $script):
        printf('<script src="%s/%s"></script>', Router::fullBaseUrl(), $script);
    endforeach;

    foreach ($appScripts as $appScript):
        printf('<script src="%s/%s"></script>', Router::fullBaseUrl(), str_replace(WWW_ROOT, '', $appScript));
    endforeach;
    ?>


    <?php echo $this->fetch('meta') ?>
</head>

<body class="smart-style-0">
<div class="wrapper" ng-controller="IndexController">

    <header id="header">
        <div id="logo-group">
            <span id="logo" ng-if="pageConfig">
                {{ pageConfig.systemname }}
            </span>
        </div>

        <div class="pull-right">


            <div id="logout" class="btn-header transparent pull-right">
                <span> <a href="/users/logout" title="Sign Out" <i class="fa fa-sign-out"></i></a> </span>
            </div>
        </div>
    </header>

    <aside id="left-panel">

        <div class="login-info" ng-if="pageConfig">
            <span>
                <a ui-sref="users_edit({'id': '{{pageConfig.auth.id}}'})" style="padding: 5px;">
                    <i class="fa fa-lg fa-user-circle-o" id=""></i>
                    <span style="padding-left: 10px;">
                        <span ng-if="pageConfig.auth.lastname && pageConfig.auth.firstname">
                            {{ pageConfig.auth.lastname }}, {{ pageConfig.auth.firstname }}
                        </span>
                        <span ng-if="!pageConfig.auth.lastname || !pageConfig.auth.firstname">
                            {{ pageConfig.auth.username }}
                        </span>
                    </span>
                </a>
            </span>
        </div>

        <nav>

            <ul>
                <li ng-class="{ 'active':isActiveMenu('dashboard') }">
                    <a ui-sref="dashboard">
                        <i class="fa fa-lg fa-fw fa-home"></i>
                        <span class="menu-item-parent"><?php echo __('Dashboard'); ?></span>
                    </a>
                </li>
                <li ng-class="{ 'active':isActiveMenu('automap') }">
                    <a ui-sref="automap"><i class="fa fa-lg fa-fw fa-magic"></i>
                        <span class="menu-item-parent"><?php echo __('Auto Map'); ?></span>
                    </a>
                </li>
                <li ng-class="{ 'active':isActiveMenu('hosts') }">
                    <a ui-sref="hosts"><i class="fa fa-lg fa-fw fa-desktop"></i>
                        <span class="menu-item-parent"><?php echo __('Hosts'); ?></span>
                    </a>
                </li>
                <li ng-class="{ 'active':isActiveMenu('services') }">
                    <a ui-sref="services"><i class="fa fa-lg fa-fw fa-cogs"></i>
                        <span class="menu-item-parent"><?php echo __('Services'); ?></span>
                    </a>
                </li>
                <li ng-class="{ 'active':isActiveMenu('users') }">
                    <a ui-sref="users"><i class="fa fa-lg fa-fw fa-user"></i>
                        <span class="menu-item-parent"><?php echo __('Manage users'); ?></span>
                    </a>
                </li>
            </ul>
        </nav>

    </aside>

    <div id="main" role="main">

        <div id="ribbon">
            <ol class="breadcrumb">
                <!-- This is auto generated -->
            </ol>

            <div class="pull-right">
                <span id="global_ajax_loader"><i class="fa fa-refresh fa-spin"></i>
                    <?php echo __('Loading data'); ?>
                </span>
            </div>
        </div>


        <?php echo $this->Flash->render() ?>
        <div id="content">
            <div ui-view></div>
        </div>


    </div>
</div>

<?php
printf('<script src="%s/%s"></script>', Router::fullBaseUrl(), 'js/menu.js');
?>

</body>
</html>

