<?php
// Copyright (C) <2015>  <it-novum GmbH>
//
// This file is dual licensed
//
// 1.
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, version 3 of the License.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// 2.
//  If you purchased an openITCOCKPIT Enterprise Edition you can use this file
//  under the terms of the openITCOCKPIT Enterprise Edition license agreement.
//  License agreement and license key will be shipped with the order
//  confirmation.
?>
<hostmenu hoststatus="hoststatus" ng-if="hoststatus"></hostmenu>

<div class="jarviswidget">

    <header role="heading">

        <h2><strong><?php echo __('Host'); ?></strong> <i><?php echo __('Checks'); ?></i></h2>
    </header>

    <div role="content">
        <div class="widget-body">

            <table class="table table-striped table-hover table-bordered default-table" role="grid">
                <thead>
                <tr>
                    <th ng-click="orderBy('state')" class="width-100 cursor-pointer">
                        <i class="fa" ng-class="getSortClass('state')"></i>
                        <?php echo __('State'); ?>
                    </th>
                    <th ng-click="orderBy('start_time')" class="cursor-pointer">
                        <i class="fa" ng-class="getSortClass('start_time')"></i>
                        <?php echo __('Date'); ?>
                    </th>
                    <th class="width-120">
                        <?php echo __('Check attempt'); ?>
                    </th>
                    <th class="width-80">
                        <?php echo __('State type'); ?>
                    </th>
                    <th ng-click="orderBy('output')" class="cursor-pointer">
                        <i class="fa" ng-class="getSortClass('output')"></i>
                        <?php echo __('Host output'); ?>
                    </th>
                </tr>
                <tr>
                    <th class="text-center smart-form">
                        <div class="inline-group">
                            <label class="checkbox small-checkbox-label">
                                <input type="checkbox" name="checkbox" checked="checked" ng-model="stateUp"
                                       ng-model-options="{debounce: 500}">
                                <i class="checkbox-success"></i>
                                &nbsp;
                            </label>
                            <label class="checkbox small-checkbox-label">
                                <input type="checkbox" name="checkbox" checked="checked" ng-model="stateDown"
                                       ng-model-options="{debounce: 500}">
                                <i class="checkbox-danger"></i>
                                &nbsp;
                            </label>
                            <label class="checkbox small-checkbox-label">
                                <input type="checkbox" name="checkbox" checked="checked" ng-model="stateUnreachable"
                                       ng-model-options="{debounce: 500}">
                                <i class="checkbox-default"></i>
                                &nbsp;
                            </label>
                        </div>
                    </th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th class="smart-form">
                        <label class="input"> <i class="icon-prepend fa fa-terminal"></i>
                            <input type="text" class="input-sm" placeholder="<?php echo __('Filter by output'); ?>"
                                   ng-model="filter_output" ng-model-options="{debounce: 500}">
                        </label>
                    </th>
                </tr>
                </thead>
                <tbody>
                <tr ng-repeat="hostcheck in hostchecks">
                    <td class="text-center">
                        <hoststatusicon currentstate="hostcheck.state"></hoststatusicon>
                    </td>
                    <td>
                        {{hostcheck.start_time * 1000 | date:'HH:mm dd.MM.yyyy'}}
                    </td>
                    <td class="text-center">
                        {{hostcheck.current_check_attempt}}/{{hostcheck.max_check_attempts}}
                    </td>
                    <td class="text-center">
                        <span class="label text-uppercase hoststatus-bg-{{ hostcheck.state}}"
                              ng-show="hostcheck.is_hardstate">
                            <?php echo __('hard state'); ?>
                        </span>
                        <span class="label text-uppercase opacity-50 hoststatus-bg-{{ hostcheck.state}}"
                              ng-show="!hostcheck.is_hardstate">
                            <?php echo __('soft state'); ?>
                        </span>
                    </td>
                    <td>
                        {{hostcheck.output}}
                    </td>
                </tr>
                <tr ng-show="hostchecks.length == 0">
                    <td colspan="5" class="text-center txt-color-red">
                        <?php echo __('No results found'); ?>
                    </td>
                </tr>
                </tbody>
            </table>
            <paginator paging="paging" click-action="changepage" ></paginator>
        </div>
    </div>
</div>