<hostmenu hoststatus="hoststatus" showbackbutton="false" ng-if="hoststatus"></hostmenu>

<div class="row">
    <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12 sortable-grid ui-sortable">

        <div class="jarviswidget jarviswidget-sortable" role="widget">
            <header role="heading">
                <h2>
                    <strong><?php echo __('Host'); ?></strong> <i><?php echo __('Details'); ?></i>
                </h2>
                <ul class="nav nav-tabs pull-right" id="widget-tab-1">
                    <li class="active">
                        <a href="javascript:void(0);" data-toggle="tab">
                            <i class="fa fa-lg fa-info"></i>
                            <span class="hidden-mobile hidden-tablet"> <?php echo __('Status information'); ?></span>
                        </a>
                    </li>
                </ul>
            </header>
            <div role="content">
                <div class="row">
                    <div class="col-xs-12">
                        <p>
                            {{ hoststatus.mapping.display_name }}
                            <strong>
                                <?php echo __('is'); ?>
                                {{ hoststatus.current_state | hostStatusName }}
                                <?php echo _('since'); ?>:
                                {{ hoststatus.last_state_change * 1000 | date:'HH:mm dd.MM.yyyy' }}
                            </strong>
                        </p>
                    </div>
                    <div class="col-xs-12">
                        <p>
                            <?php echo __('The last system check occurred at'); ?>
                            {{ hoststatus.last_state_change * 1000 | date:'HH:mm dd.MM.yyyy' }}


                            <span class="label text-uppercase hoststatus-bg-{{ hoststatus.current_state}}"
                                  ng-show="hoststatus.is_hardstate">
                                <?php echo __('hard state'); ?>
                            </span>
                            <span class="label text-uppercase opacity-50 hoststatus-bg-{{ hoststatus.current_state}}"
                                  ng-show="!hoststatus.is_hardstate">
                                <?php echo __('soft state'); ?>
                            </span>
                        </p>
                    </div>
                    <div class="col-xs-12" ng-show="hoststatus.is_flapping">
                        <div class="alert alert-info fade in">
                            <i class="fa-fw fa fa-info"></i>
                            <strong><?php echo __('Flapping!'); ?></strong>
                            <?php echo __('The state of this host is flapping.'); ?>
                        </div>
                    </div>
                    <div class="col-xs-12">
                        <table class="table table-bordered">
                            <tbody>
                            <tr>
                                <td>
                                    <strong><?php echo __('Current state'); ?>:</strong>
                                </td>
                                <td ng-if="hoststatus">
                                    <hoststatusicon currentstate="hoststatus.current_state"></hoststatusicon>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <strong><?php echo __('Flap detection'); ?>:</strong>
                                </td>
                                <td ng-if="hoststatus">
                                    <span class="label bg-color-green" ng-show="hoststatus.flap_detection_enabled">
                                        <?php echo __('On'); ?>
                                    </span>
                                    <span class="label bg-color-red" ng-show="!hoststatus.flap_detection_enabled">
                                        <?php echo __('Off'); ?>
                                    </span>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <strong><?php echo __('Active checks enabled'); ?>:</strong>
                                </td>
                                <td ng-if="hoststatus">
                                    <span class="label bg-color-green" ng-show="hoststatus.active_checks_enabled">
                                        <?php echo __('On'); ?>
                                    </span>
                                    <span class="label bg-color-red" ng-show="!hoststatus.active_checks_enabled">
                                        <?php echo __('Off'); ?>
                                    </span>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <strong><?php echo __('Check period'); ?>:</strong>
                                </td>
                                <td ng-if="hoststatus">
                                    {{hoststatus.MappingTimeperiod.display_name}}
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <strong><?php echo __('Check attempt'); ?>:</strong>
                                </td>
                                <td ng-if="hoststatus">
                                    {{hoststatus.current_check_attempt}}/{{hoststatus.max_check_attempts}}
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <strong><?php echo __('Next check in'); ?>:</strong>
                                </td>
                                <td ng-if="hoststatus">
                                    <span ng-show="hoststatus.active_checks_enabled">
                                        {{ hoststatus.next_check * 1000 | date:'HH:mm dd.MM.yyyy' }}
                                    </span>
                                    <span ng-show="!hoststatus.active_checks_enabled">
                                        <?php echo __('n/a due to passive check'); ?>
                                    </span>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <strong><?php echo __('Check interval'); ?>:</strong>
                                </td>
                                <td ng-if="hoststatus">
                                    <span ng-show="hoststatus.normal_check_interval">
                                        {{ hoststatus.normal_check_interval / 60 }}
                                        <?php echo __('minutes'); ?>
                                    </span>
                                    <span ng-show="!hoststatus.active_checks_enabled">
                                        <?php echo __('n/a due to passive check'); ?>
                                    </span>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <strong><?php echo __('Retry interval'); ?>:</strong>
                                </td>
                                <td ng-if="hoststatus">
                                    <span ng-show="hoststatus.retry_check_interval">
                                        {{ hoststatus.retry_check_interval / 60 }}
                                        <?php echo __('minutes'); ?>
                                    </span>
                                    <span ng-show="!hoststatus.active_checks_enabled">
                                        <?php echo __('n/a due to passive check'); ?>
                                    </span>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <strong><?php echo __('Output'); ?>:</strong>
                                </td>
                                <td ng-if="hoststatus">
                                    <code class="no-background hoststatus-text-{{hoststatus.current_state}}">
                                        {{ hoststatus.output }}
                                    </code>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>

                    <div class="col-xs-12" ng-show="hoststatus.long_output">
                        <p>
                            <strong>
                                <?php echo __('Long Output'); ?>:
                            </strong>
                        </p>
                    </div>
                    <div class="col-xs-12" ng-show="hoststatus.long_output">
                        <pre>{{hoststatus.long_output}}</pre>
                    </div>

                </div>
            </div>
        </div>
    </article>

    <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12 sortable-grid ui-sortable">

        <div class="jarviswidget jarviswidget-sortable" role="widget">
            <header role="heading">
                <h2>
                    <strong><?php echo __('Services'); ?></strong> <i><?php echo __('Overview'); ?></i>
                </h2>

            </header>
            <div role="content">

                <table class="table table-striped table-hover table-bordered default-table" role="grid">
                    <thead>
                    <tr>
                        <th ng-click="orderBy('current_state')" class="width-120 cursor-pointer">
                            <i class="fa" ng-class="getSortClass('current_state')"></i>
                            <?php echo __('Service status'); ?>
                        </th>
                        <th ng-click="orderBy('MappingService.display_name')" class="cursor-pointer">
                            <i class="fa" ng-class="getSortClass('MappingService.display_name')"></i>
                            <?php echo __('Service name'); ?>
                        </th>
                        <th ng-click="orderBy('active_checks_enabled')" class="width-40 cursor-pointer">
                            <i class="fa" ng-class="getSortClass('active_checks_enabled')"></i>
                            <strong title="<?php echo __('Passively transferred service'); ?>">
                                <?php echo __('P'); ?>
                            </strong>
                        </th>
                        <th ng-click="orderBy('last_state_change')" class="cursor-pointer">
                            <i class="fa" ng-class="getSortClass('last_state_change')"></i>
                            <?php echo __('State since'); ?>
                        </th>
                        <th ng-click="orderBy('last_check')" class="cursor-pointer">
                            <i class="fa" ng-class="getSortClass('last_check')"></i>
                            <?php echo __('Last check'); ?>
                        </th>
                        <th ng-click="orderBy('next_check')" class="cursor-pointer">
                            <i class="fa" ng-class="getSortClass('next_check')"></i>
                            <?php echo __('Next check'); ?>
                        </th>
                        <th ng-click="orderBy('output')" class="cursor-pointer">
                            <i class="fa" ng-class="getSortClass('output')"></i>
                            <?php echo __('Output'); ?>
                        </th>
                    </tr>
                    <tr>
                        <th class="text-center smart-form">
                            <div class="inline-group">
                                <label class="checkbox small-checkbox-label">
                                    <input type="checkbox" name="checkbox" checked="checked" ng-model="stateOk"
                                           ng-model-options="{debounce: 500}">
                                    <i class="checkbox-success"></i>
                                    &nbsp;
                                </label>
                                <label class="checkbox small-checkbox-label">
                                    <input type="checkbox" name="checkbox" checked="checked" ng-model="stateWarning"
                                           ng-model-options="{debounce: 500}">
                                    <i class="checkbox-warning"></i>
                                    &nbsp;
                                </label>
                                <label class="checkbox small-checkbox-label">
                                    <input type="checkbox" name="checkbox" checked="checked" ng-model="stateCritical"
                                           ng-model-options="{debounce: 500}">
                                    <i class="checkbox-danger"></i>
                                    &nbsp;
                                </label>
                                <label class="checkbox small-checkbox-label">
                                    <input type="checkbox" name="checkbox" checked="checked" ng-model="stateUnknown"
                                           ng-model-options="{debounce: 500}">
                                    <i class="checkbox-default"></i>
                                    &nbsp;
                                </label>
                            </div>
                        </th>
                        <th class="smart-form">
                            <label class="input"> <i class="icon-prepend fa fa-cog"></i>
                                <input type="text" class="input-sm"
                                       placeholder="<?php echo __('Filter by service name'); ?>"
                                       ng-model="filter_service_name" ng-model-options="{debounce: 500}">
                            </label>
                        </th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th class="smart-form">
                            <label class="input"> <i class="icon-prepend fa fa-terminal"></i>
                                <input type="text" class="input-sm" placeholder="<?php echo __('Filter by output'); ?>"
                                       ng-model="filter_output" ng-model-options="{debounce: 500}">
                            </label>
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr ng-repeat="service in servicestatus">
                        <td class="text-center">
                            <servicestatusicon currentstate="service.current_state"></servicestatusicon>
                        </td>
                        <td>
                            <a ui-sref="servicedetails({'hostuuid':'{{service.hostname}}', 'serviceuuid':'{{service.service_description}}'})">
                                {{ service.MappingService.display_name }}
                            </a>
                        </td>
                        <td class="text-center">
                            <strong title="<?php echo __('Passively transferred service'); ?>"
                                    ng-hide="service.active_checks_enabled">
                                <?php echo __('P'); ?>
                            </strong>
                        </td>
                        <td>
                            {{ service.last_state_change * 1000 | date:'HH:mm dd.MM.yyyy' }}
                        </td>
                        <td>
                            {{ service.last_check * 1000 | date:'HH:mm dd.MM.yyyy' }}
                        </td>
                        <td>
                        <span ng-show="service.active_checks_enabled">
                        {{ service.next_check * 1000 | date:'HH:mm dd.MM.yyyy' }}
                        </span>
                        </td>
                        <td> {{ service.output }}</td>

                    </tr>

                    <tr ng-show="servicestatus.length == 0">
                        <td colspan="7" class="text-center txt-color-red">
                            <?php echo __('No results found'); ?>
                        </td>
                    </tr>

                    </tbody>
                </table>
                <paginator paging="paging" click-action="changepage"></paginator>
            </div>
        </div>
    </article>
</div>
