<?php
// Copyright (C) <2015>  <it-novum GmbH>
//
// This file is dual licensed
//
// 1.
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, version 3 of the License.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// 2.
//  If you purchased an openITCOCKPIT Enterprise Edition you can use this file
//  under the terms of the openITCOCKPIT Enterprise Edition license agreement.
//  License agreement and license key will be shipped with the order
//  confirmation.
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-xs-12 col-sm-7 col-md-7 col-lg-4">
            <h1 class="page-title txt-color-blueDark">
                <i class="fa fa-desktop fa-fw "></i>
                <?php echo __('Hosts'); ?>
                <span>&gt;
                    <?php echo __('List'); ?>
                </span>
            </h1>
        </div>
    </div>
</div>

<div class="jarviswidget">

    <header role="heading">

        <h2><strong><?php echo __('Hosts'); ?></strong> <i><?php echo __('Overview'); ?></i></h2>
    </header>

    <div role="content">
        <div class="widget-body">

            <table class="table table-striped table-hover table-bordered default-table" role="grid">
                <thead>
                <tr>
                    <th ng-click="orderBy('current_state')" class="width-100 cursor-pointer">
                        <i class="fa" ng-class="getSortClass('current_state')"></i>
                        <?php echo __('Host status'); ?>
                    </th>
                    <th ng-click="orderBy('Mapping.display_name')" class="cursor-pointer">
                        <i class="fa" ng-class="getSortClass('Mapping.display_name')"></i>
                        <?php echo __('Host name'); ?>
                    </th>
                    <th ng-click="orderBy('active_checks_enabled')" class="width-40 cursor-pointer">
                        <i class="fa" ng-class="getSortClass('active_checks_enabled')"></i>
                        <strong title="<?php echo __('Passively transferred host'); ?>">
                            <?php echo __('P'); ?>
                        </strong>
                    </th>
                    <th ng-click="orderBy('last_state_change')" class="cursor-pointer">
                        <i class="fa" ng-class="getSortClass('last_state_change')"></i>
                        <?php echo __('State since'); ?>
                    </th>
                    <th ng-click="orderBy('last_check')" class="cursor-pointer">
                        <i class="fa" ng-class="getSortClass('last_check')"></i>
                        <?php echo __('Last check'); ?>
                    </th>
                    <th ng-click="orderBy('next_check')" class="cursor-pointer">
                        <i class="fa" ng-class="getSortClass('next_check')"></i>
                        <?php echo __('Next check'); ?>
                    </th>
                    <th ng-click="orderBy('output')" class="cursor-pointer">
                        <i class="fa" ng-class="getSortClass('output')"></i>
                        <?php echo __('Output'); ?>
                    </th>
                    <th>
                        <?php echo __('Service Summary'); ?>
                    </th>
                </tr>
                <tr>
                    <th class="text-center smart-form">
                        <div class="inline-group">
                            <label class="checkbox small-checkbox-label">
                                <input type="checkbox" name="checkbox" checked="checked" ng-model="stateUp"
                                       ng-model-options="{debounce: 500}">
                                <i class="checkbox-success"></i>
                                &nbsp;
                            </label>
                            <label class="checkbox small-checkbox-label">
                                <input type="checkbox" name="checkbox" checked="checked" ng-model="stateDown"
                                       ng-model-options="{debounce: 500}">
                                <i class="checkbox-danger"></i>
                                &nbsp;
                            </label>
                            <label class="checkbox small-checkbox-label">
                                <input type="checkbox" name="checkbox" checked="checked" ng-model="stateUnreachable"
                                       ng-model-options="{debounce: 500}">
                                <i class="checkbox-default"></i>
                                &nbsp;
                            </label>
                        </div>
                    </th>
                    <th class="smart-form">
                        <label class="input"> <i class="icon-prepend fa fa-desktop"></i>
                            <input type="text" class="input-sm" placeholder="<?php echo __('Filter by host name'); ?>"
                                   ng-model="filter_host_name" ng-model-options="{debounce: 500}">
                        </label>
                    </th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th class="smart-form">
                        <label class="input"> <i class="icon-prepend fa fa-terminal"></i>
                            <input type="text" class="input-sm" placeholder="<?php echo __('Filter by output'); ?>"
                                   ng-model="filter_output" ng-model-options="{debounce: 500}">
                        </label>
                    </th>
                    <th></th>
                </tr>
                </thead>
                <tbody>
                <tr ng-repeat="host in hoststatus">
                    <td class="text-center">
                        <hoststatusicon currentstate="host.current_state"></hoststatusicon>
                    </td>
                    <td>
                        <a ui-sref="hostdetails({'uuid':'{{host.hostname}}'})">
                            {{ host.mapping.display_name }}
                        </a>
                    </td>
                    <td class="text-center">
                        <strong title="<?php echo __('Passively transferred host'); ?>"
                                ng-hide="host.active_checks_enabled">
                            <?php echo __('P'); ?>
                        </strong>
                    </td>
                    <td>
                        {{ host.last_state_change * 1000 | date:'HH:mm dd.MM.yyyy' }}
                    </td>
                    <td>
                        {{ host.last_check * 1000 | date:'HH:mm dd.MM.yyyy' }}
                    </td>
                    <td>
                        <span ng-show="host.active_checks_enabled">
                        {{ host.next_check * 1000 | date:'HH:mm dd.MM.yyyy' }}
                        </span>
                    </td>
                    <td> {{ host.output }}</td>
                    <td>
                        <a ui-sref="services({'statename':'ok', 'hostdisplayname':'{{ host.mapping.display_name | encodeURI }}'})"
                           class="btn btn-success state-button">
                            {{host.servicestatus_summary.ok}}
                        </a>
                        <a ui-sref="services({'statename':'warning', 'hostdisplayname':'{{ host.mapping.display_name | encodeURI }}'})"
                           class="btn btn-warning state-button">
                            {{host.servicestatus_summary.warning}}
                        </a>
                        <a ui-sref="services({'statename':'critical', 'hostdisplayname':'{{ host.mapping.display_name | encodeURI }}'})"
                           class="btn btn-danger state-button">
                            {{host.servicestatus_summary.critical}}
                        </a>
                        <a ui-sref="services({'statename':'unknown', 'hostdisplayname':'{{ host.mapping.display_name | encodeURI }}'})"
                           class="btn btn-default state-button">
                            {{host.servicestatus_summary.unknown}}
                        </a>
                    </td>
                </tr>

                <tr ng-show="hoststatus.length == 0">
                    <td colspan="8" class="text-center txt-color-red">
                        <?php echo __('No results found'); ?>
                    </td>
                </tr>

                </tbody>
            </table>

            <paginator paging="paging" click-action="changepage"></paginator>

        </div>
    </div>
</div>