<?php
// Copyright (C) <2015>  <it-novum GmbH>
//
// This file is dual licensed
//
// 1.
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, version 3 of the License.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// 2.
//  If you purchased an openITCOCKPIT Enterprise Edition you can use this file
//  under the terms of the openITCOCKPIT Enterprise Edition license agreement.
//  License agreement and license key will be shipped with the order
//  confirmation.
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-xs-12 col-sm-7 col-md-7 col-lg-4">
            <h1 class="page-title txt-color-blueDark">
                <i class="fa fa-magic fa-fw "></i>
                <?php echo __('Auto map'); ?>
            </h1>
        </div>
    </div>
</div>

<hoststatusdetailsmodal></hoststatusdetailsmodal>
<servicestatusdetailsmodal></servicestatusdetailsmodal>

<div class="jarviswidget">

    <header role="heading">
        <div class="jarviswidget-ctrls padding-top-3" role="menu">
            <div class=" smart-form">
                <label class="checkbox small-checkbox-label">
                    <input type="checkbox" name="checkbox" checked="checked" ng-model="stateUnknown"
                           ng-model-options="{debounce: 500}">
                    <i class="checkbox-default"></i>
                    &nbsp;
                </label>
            </div>
        </div>
        <div class="jarviswidget-ctrls padding-top-3" role="menu">
            <div class=" smart-form">
                <label class="checkbox small-checkbox-label">
                    <input type="checkbox" name="checkbox" checked="checked" ng-model="stateCritical"
                           ng-model-options="{debounce: 500}">
                    <i class="checkbox-danger"></i>
                    &nbsp;
                </label>
            </div>
        </div>
        <div class="jarviswidget-ctrls padding-top-3" role="menu">
            <div class=" smart-form">
                <label class="checkbox small-checkbox-label">
                    <input type="checkbox" name="checkbox" checked="checked" ng-model="stateWarning"
                           ng-model-options="{debounce: 500}">
                    <i class="checkbox-warning"></i>
                    &nbsp;
                </label>
            </div>
        </div>
        <div class="jarviswidget-ctrls padding-top-3" role="menu">
            <div class=" smart-form">
                <label class="checkbox small-checkbox-label">
                    <input type="checkbox" name="checkbox" checked="checked" ng-model="stateOk"
                           ng-model-options="{debounce: 500}">
                    <i class="checkbox-success"></i>
                </label>
            </div>
        </div>
        <div class="widget-toolbar" role="menu">
            <i class="fa fa-filter"></i>
            <?php echo __('Filter Service State'); ?>
        </div>
        <div class="widget-toolbar smart-form" role="menu">
            <label class="input"> <i class="icon-prepend fa fa-cog"></i>
                <input type="text" placeholder="<?php echo __('Filter by service name'); ?>"
                       ng-model="filter_service_name" ng-model-options="{debounce: 500}">
                <i class="fa fa-warning txt-color-teal"></i>
            </label>
        </div>
        <div class="widget-toolbar smart-form" role="menu">
            <label class="input"> <i class="icon-prepend fa fa-desktop"></i>
                <input type="text" placeholder="<?php echo __('Filter by host name'); ?>"
                       ng-model="filter_host_name" ng-model-options="{debounce: 500}">
                <i class="fa fa-warning txt-color-teal"></i>
            </label>
        </div>
        <div class="jarviswidget-ctrls padding-top-3" role="menu" ng-hide="minified">
            <div class=" smart-form">
                <label class="checkbox small-checkbox-label">
                    <input type="checkbox" name="checkbox" checked="checked" ng-model="showLabel"
                           ng-disabled="minified">
                    <i class="checkbox-primary"></i>
                </label>
            </div>
        </div>
        <div class="widget-toolbar" role="menu" ng-hide="minified">
            <i class="fa fa-tag"></i>
            <?php echo __('Show label'); ?>
        </div>
        <div class="jarviswidget-ctrls padding-top-3" role="menu">
            <div class=" smart-form">
                <label class="checkbox small-checkbox-label">
                    <input type="checkbox" name="checkbox" checked="checked" ng-model="minified">
                    <i class="checkbox-primary"></i>
                </label>
            </div>
        </div>
        <div class="widget-toolbar" role="menu">
            <i class="fa fa-braille"></i>
            <?php echo __('Minified'); ?>
        </div>
        <h2><strong><?php echo __('Auto map'); ?></strong> <i><?php echo __('Overview'); ?></i></h2>
    </header>

    <div role="content">
        <div class="widget-body">

            <div ng-if="!minified">
                <fieldset class="form-group" ng-repeat="host in services">
                    <legend ng-click="showHostDetails(host)" class="cursor-pointer">
                        <hoststatusicon currentstate="host.hoststatus.current_state"></hoststatusicon>
                        {{ host.display_name }}
                    </legend>

                    <div class="col-xs-12 col-md-4 col-lg-3 ellipsis" ng-repeat="service in host.servicestatus"
                         ng-if="showLabel">
                    <span class="cursor-pointer" ng-click="showServiceDetails(service)">
                        <servicestatusicon currentstate="service.current_state"></servicestatusicon>
                        {{ service.MappingService.display_name }}
                    </span>
                    </div>


                    <div class="col-xs-12" ng-if="!showLabel">
                        <div ng-repeat="service in host.servicestatus"
                             title="{{ host.display_name }}/{{ service.MappingService.display_name }}"
                            class="display-inline-noblock">
                            <servicestatusicon
                                    currentstate="service.current_state"
                                    ng-click="showServiceDetails(service)">
                            </servicestatusicon>
                        </div>
                    </div>


                </fieldset>
            </div>

            <div ng-if="minified">
                <div ng-repeat="host in services"
                     title="{{ host.display_name }}"
                     class="display-inline-noblock">
                    <i class="fa fa-desktop" aria-hidden="true"></i>
                    <div class="display-inline-noblock" ng-click="showHostDetails(host)">
                        <hoststatusicon currentstate="host.hoststatus.current_state"></hoststatusicon>
                    </div>
                    <i class="fa fa-cogs" aria-hidden="true"></i>
                    <div ng-repeat="service in host.servicestatus"
                         class="display-inline-noblock"
                         title="{{ host.display_name }}/{{ service.MappingService.display_name }}">
                        <servicestatusicon
                                currentstate="service.current_state"
                                ng-click="showServiceDetails(service)">
                        </servicestatusicon>
                    </div>
                </div>
            </div>


            <div class="col-xs-12 txt-color-red text-center padding-top-15" ng-show="services.length == 0">
                <?php echo __('No results found'); ?>
            </div>

        </div>
    </div>
</div>
