<servicemenu servicestatus="servicestatus" hoststatus="hoststatus" showbackbutton="false"
             ng-if="servicestatus && hoststatus"></servicemenu>

<div class="row">
    <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12 sortable-grid ui-sortable">

        <div class="jarviswidget jarviswidget-sortable" role="widget">
            <header role="heading">
                <h2>
                    <strong><?php echo __('Service'); ?></strong> <i><?php echo __('Details'); ?></i>
                </h2>
                <ul class="nav nav-tabs pull-right" id="widget-tab-1">
                    <li class="active">
                        <a href="javascript:void(0);" data-toggle="tab">
                            <i class="fa fa-lg fa-info"></i>
                            <span class="hidden-mobile hidden-tablet"> <?php echo __('Status information'); ?></span>
                        </a>
                    </li>
                </ul>
            </header>
            <div role="content">
                <div class="row">
                    <div class="col-xs-12">
                        <p>
                            {{ servicestatus.mapping.display_name }}
                            <strong>
                                <?php echo __('is'); ?>
                                {{ servicestatus.current_state | serviceStatusName }}
                                <?php echo _('since'); ?>:
                                {{ servicestatus.last_state_change * 1000 | date:'HH:mm dd.MM.yyyy' }}
                            </strong>
                        </p>
                    </div>
                    <div class="col-xs-12">
                        <p>
                            <?php echo __('The last system check occurred at'); ?>
                            {{ servicestatus.last_state_change * 1000 | date:'HH:mm dd.MM.yyyy' }}


                            <span class="label text-uppercase servicestatus-bg-{{ servicestatus.current_state}}"
                                  ng-show="servicestatus.is_hardstate">
                                <?php echo __('hard state'); ?>
                            </span>
                            <span class="label text-uppercase opacity-50 servicestatus-bg-{{ servicestatus.current_state}}"
                                  ng-show="!servicestatus.is_hardstate">
                                <?php echo __('soft state'); ?>
                            </span>
                        </p>
                    </div>
                    <div class="col-xs-12" ng-show="servicestatus.is_flapping">
                        <div class="alert alert-info fade in">
                            <i class="fa-fw fa fa-info"></i>
                            <strong><?php echo __('Flapping!'); ?></strong>
                            <?php echo __('The state of this host is flapping.'); ?>
                        </div>
                    </div>
                    <div class="col-xs-12" ng-if="hoststatus">

                        <div class="parentstatus" ng-show="hoststatus.current_state > 0">
                            <?php echo __('Problem with associated host'); ?>
                            <a ui-sref="hostdetails({'uuid':'{{hoststatus.hostname}}'})">
                                {{ hoststatus.mapping.display_name }}
                            </a>
                            <?php echo __('detected'); ?>
                            <br>
                            <hoststatusicon currentstate="hoststatus.current_state"></hoststatusicon>
                            <span class="padding-left-5" style="vertical-align: middle;">
                                {{ hoststatus.current_state | hostStatusName }}
                            </span>
                            <code class="no-background hoststatus-text-{{hoststatus.current_state}}">
                                {{hoststatus.output}}
                            </code>
                        </div>
                    </div>
                    <div class="col-xs-12">
                        <table class="table table-bordered">
                            <tbody>
                            <tr>
                                <td>
                                    <strong><?php echo __('Current state'); ?>:</strong>
                                </td>
                                <td ng-if="servicestatus">
                                    <servicestatusicon currentstate="servicestatus.current_state"></servicestatusicon>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <strong><?php echo __('Flap detection'); ?>:</strong>
                                </td>
                                <td ng-if="servicestatus">
                                    <span class="label bg-color-green" ng-show="servicestatus.flap_detection_enabled">
                                        <?php echo __('On'); ?>
                                    </span>
                                    <span class="label bg-color-red" ng-show="!servicestatus.flap_detection_enabled">
                                        <?php echo __('Off'); ?>
                                    </span>
                                </td>
                            </tr>


                            <tr>
                                <td>
                                    <strong><?php echo __('Active checks enabled'); ?>:</strong>
                                </td>
                                <td ng-if="servicestatus">
                                    <span class="label bg-color-green" ng-show="servicestatus.active_checks_enabled">
                                        <?php echo __('On'); ?>
                                    </span>
                                    <span class="label bg-color-red" ng-show="!servicestatus.active_checks_enabled">
                                        <?php echo __('Off'); ?>
                                    </span>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <strong><?php echo __('Check period'); ?>:</strong>
                                </td>
                                <td ng-if="servicestatus">
                                    {{servicestatus.MappingTimeperiod.display_name}}
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <strong><?php echo __('Check attempt'); ?>:</strong>
                                </td>
                                <td ng-if="servicestatus">
                                    {{servicestatus.current_check_attempt}}/{{servicestatus.max_check_attempts}}
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <strong><?php echo __('Next check in'); ?>:</strong>
                                </td>
                                <td ng-if="servicestatus">
                                    <span ng-show="servicestatus.active_checks_enabled">
                                        {{ servicestatus.next_check * 1000 | date:'HH:mm dd.MM.yyyy' }}
                                    </span>
                                    <span ng-show="!servicestatus.active_checks_enabled">
                                        <?php echo __('n/a due to passive check'); ?>
                                    </span>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <strong><?php echo __('Check interval'); ?>:</strong>
                                </td>
                                <td ng-if="servicestatus">
                                    <span ng-show="servicestatus.normal_check_interval">
                                        {{ servicestatus.normal_check_interval / 60 }}
                                        <?php echo __('minutes'); ?>
                                    </span>
                                    <span ng-show="!servicestatus.active_checks_enabled">
                                        <?php echo __('n/a due to passive check'); ?>
                                    </span>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <strong><?php echo __('Retry interval'); ?>:</strong>
                                </td>
                                <td ng-if="servicestatus">
                                    <span ng-show="servicestatus.retry_check_interval">
                                        {{ servicestatus.retry_check_interval / 60 }}
                                        <?php echo __('minutes'); ?>
                                    </span>
                                    <span ng-show="!servicestatus.active_checks_enabled">
                                        <?php echo __('n/a due to passive check'); ?>
                                    </span>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <strong><?php echo __('Output'); ?>:</strong>
                                </td>
                                <td ng-if="servicestatus">
                                    <code class="no-background servicestatus-text-{{servicestatus.current_state}}">
                                        {{ servicestatus.output }}
                                    </code>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>

                    <div class="col-xs-12" ng-show="servicestatus.long_output">
                        <p>
                            <strong>
                                <?php echo __('Long Output'); ?>:
                            </strong>
                        </p>
                    </div>
                    <div class="col-xs-12" ng-show="servicestatus.long_output">
                        <pre>{{servicestatus.long_output}}</pre>
                    </div>

                </div>
            </div>
        </div>
    </article>
</div>
