<?php
// Copyright (C) <2015>  <it-novum GmbH>
//
// This file is dual licensed
//
// 1.
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, version 3 of the License.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// 2.
//  If you purchased an openITCOCKPIT Enterprise Edition you can use this file
//  under the terms of the openITCOCKPIT Enterprise Edition license agreement.
//  License agreement and license key will be shipped with the order
//  confirmation.
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-xs-12 col-sm-7 col-md-7 col-lg-4">
            <h1 class="page-title txt-color-blueDark">
                <i class="fa fa-cogs fa-fw "></i>
                <?php echo __('Services'); ?>
                <span>&gt;
                    <?php echo __('List'); ?>
                </span>
            </h1>
        </div>
    </div>
</div>

<div class="jarviswidget">

    <header role="heading">

        <h2><strong><?php echo __('Services'); ?></strong> <i><?php echo __('Overview'); ?></i></h2>
    </header>

    <div role="content">
        <div class="widget-body">

            <table class="table table-striped table-hover table-bordered default-table" role="grid">
                <thead>
                <tr>
                    <th ng-click="orderBy('current_state')" class="width-120 cursor-pointer" >
                        <i class="fa" ng-class="getSortClass('current_state')"></i>
                        <?php echo __('Service status'); ?>
                    </th>
                    <th ng-click="orderBy('MappingHost.display_name')" class="cursor-pointer">
                        <i class="fa" ng-class="getSortClass('MappingHost.display_name')"></i>
                        <?php echo __('Host name'); ?>
                    </th>
                    <th ng-click="orderBy('MappingService.display_name')" class="cursor-pointer">
                        <i class="fa" ng-class="getSortClass('MappingService.display_name')"></i>
                        <?php echo __('Service name'); ?>
                    </th>
                    <th ng-click="orderBy('active_checks_enabled')" class="width-40 cursor-pointer">
                        <i class="fa" ng-class="getSortClass('active_checks_enabled')"></i>
                        <strong title="<?php echo __('Passively transferred service'); ?>">
                            <?php echo __('P'); ?>
                        </strong>
                    </th>
                    <th ng-click="orderBy('last_state_change')" class="cursor-pointer">
                        <i class="fa" ng-class="getSortClass('last_state_change')"></i>
                        <?php echo __('State since'); ?>
                    </th>
                    <th ng-click="orderBy('last_check')" class="cursor-pointer">
                        <i class="fa" ng-class="getSortClass('last_check')"></i>
                        <?php echo __('Last check'); ?>
                    </th>
                    <th ng-click="orderBy('next_check')" class="cursor-pointer">
                        <i class="fa" ng-class="getSortClass('next_check')"></i>
                        <?php echo __('Next check'); ?>
                    </th>
                    <th ng-click="orderBy('output')" class="cursor-pointer">
                        <i class="fa" ng-class="getSortClass('output')"></i>
                        <?php echo __('Output'); ?>
                    </th>
                </tr>
                <tr>
                    <th class="text-center smart-form">
                        <div class="inline-group">
                            <label class="checkbox small-checkbox-label">
                                <input type="checkbox" name="checkbox" checked="checked" ng-model="stateOk"
                                       ng-model-options="{debounce: 500}">
                                <i class="checkbox-success"></i>
                                &nbsp;
                            </label>
                            <label class="checkbox small-checkbox-label">
                                <input type="checkbox" name="checkbox" checked="checked" ng-model="stateWarning"
                                       ng-model-options="{debounce: 500}">
                                <i class="checkbox-warning"></i>
                                &nbsp;
                            </label>
                            <label class="checkbox small-checkbox-label">
                                <input type="checkbox" name="checkbox" checked="checked" ng-model="stateCritical"
                                       ng-model-options="{debounce: 500}">
                                <i class="checkbox-danger"></i>
                                &nbsp;
                            </label>
                            <label class="checkbox small-checkbox-label">
                                <input type="checkbox" name="checkbox" checked="checked" ng-model="stateUnknown"
                                       ng-model-options="{debounce: 500}">
                                <i class="checkbox-default"></i>
                                &nbsp;
                            </label>
                        </div>
                    </th>
                    <th class="smart-form">
                        <label class="input"> <i class="icon-prepend fa fa-desktop"></i>
                            <input type="text" class="input-sm" placeholder="<?php echo __('Filter by host name'); ?>"
                                   ng-model="filter_host_name" ng-model-options="{debounce: 500}">
                        </label>
                    </th>
                    <th class="smart-form">
                        <label class="input"> <i class="icon-prepend fa fa-cog"></i>
                            <input type="text" class="input-sm"
                                   placeholder="<?php echo __('Filter by service name'); ?>"
                                   ng-model="filter_service_name" ng-model-options="{debounce: 500}">
                        </label>
                    </th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th class="smart-form">
                        <label class="input"> <i class="icon-prepend fa fa-terminal"></i>
                            <input type="text" class="input-sm" placeholder="<?php echo __('Filter by output'); ?>"
                                   ng-model="filter_output" ng-model-options="{debounce: 500}">
                        </label>
                    </th>
                </tr>
                </thead>
                <tbody>
                <tr ng-repeat="service in servicestatus">
                    <td class="text-center">
                        <servicestatusicon currentstate="service.current_state"></servicestatusicon>
                    </td>
                    <td class="table-color-{{service.StatusengineHoststatus.current_state}}">
                        <a ui-sref="hostdetails({'uuid':'{{service.hostname}}'})">
                            {{ service.MappingHost.display_name }}
                        </a>
                    </td>
                    <td>
                        <a ui-sref="servicedetails({'hostuuid':'{{service.hostname}}', 'serviceuuid':'{{service.service_description}}'})">
                            {{ service.MappingService.display_name }}
                        </a>
                    </td>
                    <td class="text-center">
                        <strong title="<?php echo __('Passively transferred service'); ?>"
                                ng-hide="service.active_checks_enabled">
                            <?php echo __('P'); ?>
                        </strong>
                    </td>
                    <td>
                        {{ service.last_state_change * 1000 | date:'HH:mm dd.MM.yyyy' }}
                    </td>
                    <td>
                        {{ service.last_check * 1000 | date:'HH:mm dd.MM.yyyy' }}
                    </td>
                    <td>
                        <span ng-show="service.active_checks_enabled">
                        {{ service.next_check * 1000 | date:'HH:mm dd.MM.yyyy' }}
                        </span>
                    </td>
                    <td> {{ service.output }}</td>

                </tr>

                <tr ng-show="servicestatus.length == 0">
                    <td colspan="8" class="text-center txt-color-red">
                        <?php echo __('No results found'); ?>
                    </td>
                </tr>

                </tbody>
            </table>
            <paginator paging="paging" click-action="changepage"></paginator>

        </div>
    </div>
</div>