<?php
// Copyright (C) <2015>  <it-novum GmbH>
//
// This file is dual licensed
//
// 1.
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, version 3 of the License.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// 2.
//  If you purchased an openITCOCKPIT Enterprise Edition you can use this file
//  under the terms of the openITCOCKPIT Enterprise Edition license agreement.
//  License agreement and license key will be shipped with the order
//  confirmation.

?>

<div id="serviceDetailsModal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    {{ servicedetails.mapping.display_name }}
                    <small>
                        {{ modalHostname }}
                    </small>
                </h4>
            </div>
            <div class="modal-body">
                <table class="table table-bordered">
                    <tbody>
                    <tr>
                        <td>
                            <strong><?php echo __('Current state'); ?>:</strong>
                        </td>
                        <td ng-if="servicedetails">
                            <servicestatusicon currentstate="servicedetails.current_state"></servicestatusicon>
                        </td>
                    </tr>

                    <tr>
                        <td>
                            <strong><?php echo __('Flap detection'); ?>:</strong>
                        </td>
                        <td ng-if="servicedetails">
                                    <span class="label bg-color-green" ng-show="servicedetails.flap_detection_enabled">
                                        <?php echo __('On'); ?>
                                    </span>
                            <span class="label bg-color-red" ng-show="!servicedetails.flap_detection_enabled">
                                        <?php echo __('Off'); ?>
                                    </span>
                        </td>
                    </tr>

                    <tr>
                        <td>
                            <strong><?php echo __('Active checks enabled'); ?>:</strong>
                        </td>
                        <td ng-if="servicedetails">
                                    <span class="label bg-color-green" ng-show="servicedetails.active_checks_enabled">
                                        <?php echo __('On'); ?>
                                    </span>
                            <span class="label bg-color-red" ng-show="!servicedetails.active_checks_enabled">
                                        <?php echo __('Off'); ?>
                                    </span>
                        </td>
                    </tr>

                    <tr>
                        <td>
                            <strong><?php echo __('Check period'); ?>:</strong>
                        </td>
                        <td ng-if="servicedetails">
                            {{servicedetails.MappingTimeperiod.display_name}}
                        </td>
                    </tr>

                    <tr>
                        <td>
                            <strong><?php echo __('Check attempt'); ?>:</strong>
                        </td>
                        <td ng-if="servicedetails">
                            {{servicedetails.current_check_attempt}}/{{servicedetails.max_check_attempts}}
                        </td>
                    </tr>

                    <tr>
                        <td>
                            <strong><?php echo __('Next check in'); ?>:</strong>
                        </td>
                        <td ng-if="servicedetails">
                                    <span ng-show="servicedetails.active_checks_enabled">
                                        {{ servicedetails.next_check * 1000 | date:'HH:mm dd.MM.yyyy' }}
                                    </span>
                            <span ng-show="!servicedetails.active_checks_enabled">
                                        <?php echo __('n/a due to passive check'); ?>
                                    </span>
                        </td>
                    </tr>

                    <tr>
                        <td>
                            <strong><?php echo __('Check interval'); ?>:</strong>
                        </td>
                        <td ng-if="servicedetails">
                                    <span ng-show="servicedetails.normal_check_interval">
                                        {{ servicedetails.normal_check_interval / 60 }}
                                        <?php echo __('minutes'); ?>
                                    </span>
                            <span ng-show="!servicedetails.active_checks_enabled">
                                        <?php echo __('n/a due to passive check'); ?>
                                    </span>
                        </td>
                    </tr>

                    <tr>
                        <td>
                            <strong><?php echo __('Retry interval'); ?>:</strong>
                        </td>
                        <td ng-if="servicedetails">
                                    <span ng-show="servicedetails.retry_check_interval">
                                        {{ servicedetails.retry_check_interval / 60 }}
                                        <?php echo __('minutes'); ?>
                                    </span>
                            <span ng-show="!servicedetails.active_checks_enabled">
                                        <?php echo __('n/a due to passive check'); ?>
                                    </span>
                        </td>
                    </tr>

                    <tr>
                        <td>
                            <strong><?php echo __('Output'); ?>:</strong>
                        </td>
                        <td ng-if="servicedetails">
                            <code class="no-background servicestatus-text-{{servicedetails.current_state}}">
                                {{ servicedetails.output }}
                            </code>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" ng-click="goToServiceDetails()">
                    <?php echo __('Details'); ?>
                </button>
                <button type="button" class="btn btn-default" data-dismiss="modal">
                    <?php echo __('Close'); ?>
                </button>
            </div>
        </div>
    </div>
</div>
