<?php
// Copyright (C) <2015>  <it-novum GmbH>
//
// This file is dual licensed
//
// 1.
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, version 3 of the License.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// 2.
//  If you purchased an openITCOCKPIT Enterprise Edition you can use this file
//  under the terms of the openITCOCKPIT Enterprise Edition license agreement.
//  License agreement and license key will be shipped with the order
//  confirmation.
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-xs-12 col-sm-7 col-md-7 col-lg-4">
            <h1 class="page-title txt-color-blueDark">
                <i class="fa fa-user fa-fw "></i>
                <?php echo __('User'); ?>
                <span>&gt;
                    <?php echo __('Add'); ?>
                </span>
            </h1>
        </div>
    </div>
</div>

<div class="jarviswidget">

    <header role="heading">

        <h2><strong><?php echo __('User'); ?></strong> <i><?php echo __('add'); ?></i></h2>
    </header>

    <div role="content">
        <form ng-submit="submit();">
            <div class="widget-body smart-form no-padding">
                <div class="col-xs-12 col-lg-6">
                    <fieldset>
                        <section>
                            <label class="input" ng-class="{'state-error': errors.username}">
                                <i class="icon-prepend fa fa-user"></i>
                                <input type="text" name="username" placeholder="<?php echo __('Username'); ?>"
                                       ng-model="post_username">
                            </label>
                            <div ng-repeat="error in errors.username">
                                <div class="note txt-color-red">{{ error }}</div>
                            </div>
                        </section>


                        <section>
                            <label class="input" ng-class="{'state-error': errors.firstname}">
                                <i class="icon-prepend fa fa-pencil"></i>
                                <input type="text" name="firstname" placeholder="<?php echo __('First name'); ?>"
                                       ng-model="post_firstname">
                            </label>
                            <div ng-repeat="error in errors.firstname">
                                <div class="note txt-color-red">{{ error }}</div>
                            </div>
                        </section>

                        <section>
                            <label class="input" ng-class="{'state-error': errors.lastname}">
                                <i class="icon-prepend fa fa-pencil"></i>
                                <input type="text" name="lastname" placeholder="<?php echo __('Last name'); ?>"
                                       ng-model="post_lastname">
                            </label>
                            <div ng-repeat="error in errors.lastname">
                                <div class="note txt-color-red">{{ error }}</div>
                            </div>
                        </section>


                        <section>
                            <label class="input" ng-class="{'state-error': errors.password}">
                                <i class="icon-prepend fa fa-lock"></i>
                                <input type="password" name="password" placeholder="<?php echo __('Password'); ?>"
                                       ng-model="post_password">
                            </label>
                            <div ng-repeat="error in errors.password">
                                <div class="note txt-color-red">{{ error }}</div>
                            </div>
                        </section>

                        <section>
                            <label class="input" ng-class="{'state-error': errors.password_confirm}">
                                <i class="icon-prepend fa fa-lock"></i>
                                <input type="password" name="password_confirm"
                                       placeholder="<?php echo __('Confirm password'); ?>"
                                       ng-model="post_password_confirm">
                            </label>
                            <div ng-repeat="error in errors.password_confirm">
                                <div class="note txt-color-red">{{ error }}</div>
                            </div>
                        </section>
                    </fieldset>

                </div>
                <div class="col-xs-12">
                    <footer>
                        <div class="col-xs-12 col-lg-6">
                            <a class="btn btn-default" ui-sref="users">
                                <?php echo __('Cancel'); ?>
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <?php echo __('Save'); ?>
                            </button>
                        </div>
                    </footer>
                </div>
            </div>
        </form>
    </div>
</div>
