<?php
// Copyright (C) <2015>  <it-novum GmbH>
//
// This file is dual licensed
//
// 1.
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, version 3 of the License.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// 2.
//  If you purchased an openITCOCKPIT Enterprise Edition you can use this file
//  under the terms of the openITCOCKPIT Enterprise Edition license agreement.
//  License agreement and license key will be shipped with the order
//  confirmation.
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-xs-12 col-sm-7 col-md-7 col-lg-4">
            <h1 class="page-title txt-color-blueDark">
                <i class="fa fa-user fa-fw "></i>
                <?php echo __('Users'); ?>
                <span>&gt;
                    <?php echo __('List'); ?>
                </span>
            </h1>
        </div>
    </div>
</div>

<div class="jarviswidget">

    <header role="heading">

        <div class="widget-toolbar" role="menu">
            <a ui-sref="users_add" class="btn btn-xs btn-success">
                <i class="fa fa-plus"></i>
                <?php echo __('Add user'); ?>
            </a>
        </div>
        <h2><strong><?php echo __('Users'); ?></strong> <i><?php echo __('Overview'); ?></i></h2>
    </header>

    <div role="content">
        <div class="widget-body">

            <table class="table table-striped table-hover table-bordered default-table" role="grid">
                <thead>
                <tr>
                    <th ng-click="orderBy('username')" class="cursor-pointer">
                        <i class="fa" ng-class="getSortClass('username')"></i>
                        <?php echo __('Username'); ?>
                    </th>
                    <th ng-click="orderBy('firstname')" class="cursor-pointer">
                        <i class="fa" ng-class="getSortClass('firstname')"></i>
                        <?php echo __('First name'); ?>
                    </th>
                    <th ng-click="orderBy('lastname')" class="cursor-pointer">
                        <i class="fa" ng-class="getSortClass('lastname')"></i>
                        <?php echo __('Last name'); ?>
                    </th>
                    <th class="text-center width-75">
                        <i class="fa fa-cog fa-lg"></i>
                    </th>
                </tr>
                <tr>
                    <th class="smart-form">
                        <label class="input"> <i class="icon-prepend fa fa-filter"></i>
                            <input type="text" class="input-sm" placeholder="<?php echo __('Filter by username'); ?>"
                                   ng-model="filter_username" ng-model-options="{debounce: 500}">
                        </label>
                    </th>
                    <th class="smart-form">
                        <label class="input"> <i class="icon-prepend fa fa-filter"></i>
                            <input type="text" class="input-sm" placeholder="<?php echo __('Filter by first name'); ?>"
                                   ng-model="filter_firstname" ng-model-options="{debounce: 500}">
                        </label>
                    </th>
                    <th class="smart-form">
                        <label class="input"> <i class="icon-prepend fa fa-filter"></i>
                            <input type="text" class="input-sm" placeholder="<?php echo __('Filter by last name'); ?>"
                                   ng-model="filter_lastname" ng-model-options="{debounce: 500}">
                        </label>
                    </th>
                    <th></th>
                </tr>
                </thead>
                <tbody>
                <tr ng-repeat="user in users">
                    <td> {{ user.username }}</td>
                    <td> {{ user.firstname }}</td>
                    <td> {{ user.lastname }}</td>
                    <td class="text-center smart-form">
                        <div class="btn-group">
                            <a ui-sref="users_edit({'id': '{{user.id}}'})" class="btn btn-default">
                                &nbsp;<i class="fa fa-cog"></i>&nbsp;
                            </a>
                            <a href="javascript:void(0);" data-toggle="dropdown" class="btn btn-default dropdown-toggle"
                               aria-expanded="false">
                                <span class="caret"></span>
                            </a>
                            <ul class="dropdown-menu pull-right padding-5">
                                <li>
                                    <a ui-sref="users_edit({'id': '{{user.id}}'})">
                                        <i class="fa fa-cog"></i>
                                        <?php echo __('Edit'); ?>
                                    </a>
                                </li>
                                <li class="divider"></li>
                                <li>
                                    <a href="javascript:void(0);" ng-click="delete(user.id)" class="txt-color-red">
                                        <i class="fa fa-trash-o"></i>
                                        <?php echo __('Delete'); ?>
                                    </a>
                                </li>
                            </ul>
                        </div>

                    </td>
                </tr>

                <tr ng-show="users.length == 0">
                    <td colspan="8" class="text-center txt-color-red">
                        <?php echo __('No results found'); ?>
                    </td>
                </tr>

                </tbody>
            </table>

            <paginator paging="paging" click-action="changepage"></paginator>

        </div>
    </div>
</div>