angular.module('openITCOCKPIT')
    .controller('AutomapController', function($scope, $http, $interval){

        /** Filter settings **/
        $scope.stateOk = true;
        $scope.stateWarning = true;
        $scope.stateCritical = true;
        $scope.stateUnknown = true;
        $scope.current_state = [];
        $scope.filter_host_name = '';
        $scope.filter_service_name = '';
        /** End filter Settings **/

        $scope.showLabel = false;
        $scope.minified = true;

        $scope.init = true;
        $scope.load = function(){
            $http.get("/StatusengineServicestatus/automap.json", {
                params: {
                    'filter[StatusengineServicestatus.current_state][]': $scope.current_state,
                    'filter[MappingHost.display_name]': $scope.filter_host_name,
                    'filter[MappingService.display_name]': $scope.filter_service_name,
                }
            }).then(function(result){
                $scope.services = result.data.services;
                $scope.paging = result.data.paging;
                $scope.init = false;
            });

        };

        $scope.$watchGroup(['stateOk', 'stateWarning', 'stateCritical', 'stateUnknown', 'filter_host_name', 'filter_service_name'], function(){
            if($scope.init){
                return;
            }
            $scope.current_state = [];
            if($scope.stateOk){
                $scope.current_state.push('ok');
            }
            if($scope.stateWarning){
                $scope.current_state.push('warning');
            }
            if($scope.stateCritical){
                $scope.current_state.push('critical');
            }
            if($scope.stateUnknown){
                $scope.current_state.push('unknown');
            }
            $scope.load();
        });

        $scope.Timer = $interval($scope.load, 30000);

        $scope.$on("$destroy", function(){
            if (angular.isDefined($scope.Timer)) {
                $interval.cancel($scope.Timer);
            }
        });

        $scope.load();
    });