angular.module('openITCOCKPIT')
    .controller('HostChecksController', function($scope, $http, $stateParams, SortService){

        $scope.paging = {};
        $scope.currentPage = 1;
        SortService.setSort('start_time');
        SortService.setDirection('desc');

        /** Filter settings **/
        $scope.stateUp = true;
        $scope.stateDown = true;
        $scope.stateUnreachable = true;
        $scope.current_state = [];
        $scope.filter_output = '';
        /** End filter Settings **/

        $scope.init = true;

        $scope.load = function(){
            $http.get("/StatusengineHostchecks/index.json", {
                params: {
                    page: $scope.currentPage,
                    sort: SortService.getSort(),
                    direction: SortService.getDirection(),
                    'filter[StatusengineHostchecks.hostname]':$stateParams.uuid,
                    'filter[StatusengineHostchecks.state][]':$scope.current_state,
                    'filter[StatusengineHostchecks.output]':$scope.filter_output
                }
            }).then(function(result){
                $scope.hostchecks = result.data.hostchecks;
                $scope.paging = result.data.paging;
                $scope.init = false;
            });
        };

        $scope.loadHoststatus = function(){
            $http.get("/StatusengineHoststatus/index.json", {
                params: {
                    'filter[StatusengineHoststatus.hostname]':$stateParams.uuid
                }
            }).then(function(result){
                $scope.hoststatus = result.data.hoststatus[0];
            });
        };

        $scope.changepage = function(page){
            if(page !== $scope.currentPage){
                $scope.currentPage = page;
                $scope.load();
            }
        };

        $scope.$watchGroup(['stateUp', 'stateDown', 'stateUnreachable', 'filter_output'], function(){
            if($scope.init){
                return;
            }
            $scope.current_state = [];
            if($scope.stateUp){
                $scope.current_state.push('up');
            }
            if($scope.stateDown){
                $scope.current_state.push('down');
            }
            if($scope.stateUnreachable){
                $scope.current_state.push('unreachable');
            }
            $scope.load();
        });

        SortService.setCallback($scope.load);
        SortService.triggerReload();

        $scope.loadHoststatus();


        if ($("[rel=tooltip]").length) {
            $("[rel=tooltip]").tooltip();
        }

    });