angular.module('openITCOCKPIT')
    .controller('HostController', function($scope, $http, $stateParams, SortService){

        $scope.paging = {};
        $scope.currentPage = 1;

        SortService.setSort('current_state');
        SortService.setDirection('desc');

        /** Filter settings **/
        $scope.stateUp = true;
        $scope.stateDown = true;
        $scope.stateUnreachable = true;
        $scope.current_state = [];
        $scope.filter_host_name = '';
        $scope.filter_output = '';
        /** End filter Settings **/

        $scope.init = true;
        $scope.load = function(){
            $http.get("/StatusengineHoststatus/index.json", {
                params: {
                    page: $scope.currentPage,
                    sort: SortService.getSort(),
                    direction: SortService.getDirection(),
                    'filter[current_state][]': $scope.current_state,
                    'filter[Mapping.display_name]': $scope.filter_host_name,
                    'filter[output]': $scope.filter_output
                }
            }).then(function(result){
                $scope.hoststatus = result.data.hoststatus;
                $scope.paging = result.data.paging;
                $scope.init = false;
            });

        };

        $scope.parseUrlFilter = function(){
            if($stateParams.statename){
                $scope.stateUp = false;
                $scope.stateDown = false;
                $scope.stateUnreachable = false;
                switch($stateParams.statename){
                    case 'up':
                        $scope.stateUp = true;
                        break;
                    case 'down':
                        $scope.stateDown = true;
                        break;
                    default:
                        $stateParams.statename = 'unreachable';
                        $scope.stateUnreachable = true;
                        break;
                }
                $scope.current_state = [$stateParams.statename];
            }
        };

        $scope.changepage = function(page){
            if(page !== $scope.currentPage){
                $scope.currentPage = page;
                $scope.load();
            }
        };


        $scope.$watchGroup(['stateUp', 'stateDown', 'stateUnreachable', 'filter_host_name', 'filter_output'], function(){
            if($scope.init){
                return;
            }
            $scope.current_state = [];
            if($scope.stateUp){
                $scope.current_state.push('up');
            }
            if($scope.stateDown){
                $scope.current_state.push('down');
            }
            if($scope.stateUnreachable){
                $scope.current_state.push('unreachable');
            }
            $scope.load();
        });

        $scope.parseUrlFilter();
        SortService.setCallback($scope.load);
        SortService.triggerReload();

    });