angular.module('openITCOCKPIT')
    .controller('HostDetailsController', function($scope, $http, $stateParams, SortService){

        $scope.paging = {};
        $scope.currentPage = 1;
        SortService.setSort('current_state');
        SortService.setDirection('desc');

        /** Filter settings **/
        $scope.stateOk = true;
        $scope.stateWarning = true;
        $scope.stateCritical = true;
        $scope.stateUnknown = true;
        $scope.current_state = [];
        $scope.filter_service_name = '';
        $scope.filter_output = '';
        /** End filter Settings **/

        $scope.init = true;
        $scope.load = function(){
            $http.get("/StatusengineHoststatus/details.json", {
                params: {
                    uuid: $stateParams.uuid
                }
            }).then(function(result){
                $scope.hoststatus = result.data.hoststatus;
                $scope.init = false;
                $scope.loadServices(); //Fires on load of page
            });
        };

        $scope.loadServices = function(){
            if($scope.init){
                return;
            }

            $http.get("/StatusengineServicestatus/index.json", {
                params: {
                    'filter[StatusengineServicestatus.hostname]':$stateParams.uuid,
                    page: $scope.currentPage,
                    sort: SortService.getSort(),
                    direction: SortService.getDirection(),
                    'filter[StatusengineServicestatus.current_state][]': $scope.current_state,
                    'filter[MappingService.display_name]': $scope.filter_service_name,
                    'filter[StatusengineServicestatus.output]': $scope.filter_output
                }
            }).then(function(result){
                $scope.servicestatus = result.data.servicestatus;
                $scope.paging = result.data.paging;
            });
        };

        $scope.changepage = function(page){
            //Click on next page in paginator
            if(page !== $scope.currentPage){
                $scope.currentPage = page;
                $scope.loadServices();
            }
        };

        $scope.$watchGroup(['stateOk', 'stateWarning', 'stateCritical', 'stateUnknown', 'filter_service_name', 'filter_output'], function(){
            if($scope.init){
                return;
            }
            $scope.current_state = [];
            if($scope.stateOk){
                $scope.current_state.push('ok');
            }
            if($scope.stateWarning){
                $scope.current_state.push('warning');
            }
            if($scope.stateCritical){
                $scope.current_state.push('critical');
            }
            if($scope.stateUnknown){
                $scope.current_state.push('unknown');
            }
            //Load on filter
            $scope.loadServices();
        });

        //Sort/direction reload
        SortService.setCallback($scope.loadServices);
        SortService.triggerReload();


        $scope.load();

        if ($("[rel=tooltip]").length) {
            $("[rel=tooltip]").tooltip();
        }

    });