angular.module('openITCOCKPIT')
    .controller('HostStatehistoryController', function($scope, $http, $stateParams, SortService){

        $scope.paging = {};
        $scope.currentPage = 1;
        SortService.setSort('state_time')
        SortService.setDirection('desc');

        /** Filter settings **/
        $scope.stateUp = true;
        $scope.stateDown = true;
        $scope.stateUnreachable = true;
        $scope.state = [];
        $scope.filter_output = '';
        /** End filter Settings **/

        $scope.init = true;

        $scope.load = function(){
            $http.get("/StatusengineHostStatehistory/index.json", {
                params: {
                    page: $scope.currentPage,
                    sort: SortService.getSort(),
                    direction: SortService.getDirection(),
                    'filter[StatusengineHostStatehistory.hostname]':$stateParams.uuid,
                    'filter[StatusengineHostStatehistory.state][]':$scope.state,
                    'filter[StatusengineHostStatehistory.output]':$scope.filter_output
                }
            }).then(function(result){
                $scope.hoststatehistory = result.data.hoststatehistory;
                $scope.paging = result.data.paging;
                $scope.init = false;
            });
        };

        $scope.loadHoststatus = function(){
            $http.get("/StatusengineHoststatus/index.json", {
                params: {
                    'filter[StatusengineHoststatus.hostname]':$stateParams.uuid
                }
            }).then(function(result){
                $scope.hoststatus = result.data.hoststatus[0];
            });
        };

        $scope.changepage = function(page){
            if(page !== $scope.currentPage){
                $scope.currentPage = page;
                $scope.load();
            }
        };

        $scope.$watchGroup(['stateUp', 'stateDown', 'stateUnreachable', 'filter_output'], function(){
            if($scope.init){
                return;
            }
            $scope.state = [];
            if($scope.stateUp){
                $scope.state.push('up');
            }
            if($scope.stateDown){
                $scope.state.push('down');
            }
            if($scope.stateUnreachable){
                $scope.state.push('unreachable');
            }
            $scope.load();
        });

        SortService.setCallback($scope.load);
        SortService.triggerReload();

        $scope.loadHoststatus();


        if ($("[rel=tooltip]").length) {
            $("[rel=tooltip]").tooltip();
        }

    });