angular.module('openITCOCKPIT')
    .controller('ServiceChecksController', function($scope, $http, $stateParams, SortService){

        $scope.paging = {};
        $scope.currentPage = 1;
        SortService.setSort('start_time');
        SortService.setDirection('desc');

        /** Filter settings **/
        $scope.stateOk = true;
        $scope.stateWarning = true;
        $scope.stateCritical = true;
        $scope.stateUnknown = true;
        $scope.current_state = [];
        $scope.filter_output = '';
        /** End filter Settings **/

        $scope.init = true;

        $scope.load = function(){
            $http.get("/StatusengineServicechecks/index.json", {
                params: {
                    page: $scope.currentPage,
                    sort: SortService.getSort(),
                    direction: SortService.getDirection(),
                    'filter[StatusengineServicechecks.service_description]':$stateParams.serviceuuid,
                    'filter[StatusengineServicechecks.state][]':$scope.current_state,
                    'filter[StatusengineServicechecks.output]':$scope.filter_output
                }
            }).then(function(result){
                $scope.servicechecks = result.data.servicechecks;
                $scope.paging = result.data.paging;
                $scope.init = false;
            });
        };

        $scope.loadServicestatus = function(){
            $http.get("/StatusengineServicestatus/index.json", {
                params: {
                    'filter[StatusengineServicestatus.service_description]':$stateParams.serviceuuid
                }
            }).then(function(result){
                $scope.servicestatus = result.data.servicestatus[0];
            });
        };

        $scope.changepage = function(page){
            if(page !== $scope.currentPage){
                $scope.currentPage = page;
                $scope.load();
            }
        };

        $scope.$watchGroup(['stateOk', 'stateWarning', 'stateCritical', 'stateUnknown', 'filter_output'], function(){
            if($scope.init){
                return;
            }
            $scope.current_state = [];
            if($scope.stateOk){
                $scope.current_state.push('ok');
            }
            if($scope.stateWarning){
                $scope.current_state.push('warning');
            }
            if($scope.stateCritical){
                $scope.current_state.push('critical');
            }
            if($scope.stateUnknown){
                $scope.current_state.push('unknown');
            }
            $scope.load();
        });

        SortService.setCallback($scope.load);
        SortService.triggerReload();

        $scope.loadServicestatus();


        if ($("[rel=tooltip]").length) {
            $("[rel=tooltip]").tooltip();
        }

    });