angular.module('openITCOCKPIT')
    .controller('ServiceController', function($scope, $http, $stateParams, SortService){

        $scope.paging = {};
        $scope.currentPage = 1;
        SortService.setSort('current_state');
        SortService.setDirection('desc');

        /** Filter settings **/
        $scope.stateOk = true;
        $scope.stateWarning = true;
        $scope.stateCritical = true;
        $scope.stateUnknown = true;
        $scope.current_state = [];//
        $scope.filter_host_name = '';
        $scope.filter_service_name = '';
        $scope.filter_output = '';
        /** End filter Settings **/

        $scope.init = true;
        $scope.load = function(){
            $http.get("/StatusengineServicestatus/index.json", {
                params: {
                    page: $scope.currentPage,
                    sort: SortService.getSort(),
                    direction: SortService.getDirection(),
                    'filter[StatusengineServicestatus.current_state][]': $scope.current_state,
                    'filter[MappingHost.display_name]': $scope.filter_host_name,
                    'filter[MappingService.display_name]': $scope.filter_service_name,
                    'filter[StatusengineServicestatus.output]': $scope.filter_output
                }
            }).then(function(result){
                $scope.servicestatus = result.data.servicestatus;
                $scope.paging = result.data.paging;
                $scope.init = false;
            });

        };

        $scope.parseUrlFilter = function(){
            if($stateParams.statename){
                $scope.stateOk = false;
                $scope.stateWarning = false;
                $scope.stateCritical = false;
                $scope.stateUnknown = false;
                switch($stateParams.statename){
                    case 'ok':
                        $scope.stateOk = true;
                        break;
                    case 'warning':
                        $scope.stateWarning = true;
                        break;
                    case 'critical':
                        $scope.stateCritical = true;
                        break;
                    default:
                        $stateParams.statename = 'unknown';
                        $scope.stateUnknown = true;
                        break;
                }
                $scope.current_state = [$stateParams.statename];
            }

            if($stateParams.hostdisplayname){
                $scope.filter_host_name = decodeURI($stateParams.hostdisplayname);
            }
        };

        $scope.changepage = function(page){
            if(page !== $scope.currentPage){
                $scope.currentPage = page;
                $scope.load();
            }
        };


        $scope.$watchGroup(['stateOk', 'stateWarning', 'stateCritical', 'stateUnknown', 'filter_host_name', 'filter_service_name', 'filter_output'], function(){
            if($scope.init){
                return;
            }
            $scope.current_state = [];
            if($scope.stateOk){
                $scope.current_state.push('ok');
            }
            if($scope.stateWarning){
                $scope.current_state.push('warning');
            }
            if($scope.stateCritical){
                $scope.current_state.push('critical');
            }
            if($scope.stateUnknown){
                $scope.current_state.push('unknown');
            }
            $scope.load();
        });

        $scope.parseUrlFilter();
        SortService.setCallback($scope.load);
        SortService.triggerReload();

    });
