angular.module('openITCOCKPIT')
    .controller('ServiceStatehistoryController', function($scope, $http, $stateParams, SortService){

        $scope.paging = {};
        $scope.currentPage = 1;
        SortService.setSort('start_time');
        SortService.setDirection('desc');

        /** Filter settings **/
        $scope.stateOk = true;
        $scope.stateWarning = true;
        $scope.stateCritical = true;
        $scope.stateUnknown = true;
        $scope.state = [];
        $scope.filter_output = '';
        /** End filter Settings **/

        $scope.init = true;

        $scope.load = function(){
            $http.get("/StatusengineServiceStatehistory/index.json", {
                params: {
                    page: $scope.currentPage,
                    sort: SortService.getSort(),
                    direction: SortService.getDirection(),
                    'filter[StatusengineServiceStatehistory.service_description]':$stateParams.serviceuuid,
                    'filter[StatusengineServiceStatehistory.state][]':$scope.state,
                    'filter[StatusengineServiceStatehistory.output]':$scope.filter_output
                }
            }).then(function(result){
                $scope.servicestatehistory = result.data.servicestatehistory;
                $scope.paging = result.data.paging;
                $scope.init = false;
            });
        };

        $scope.loadServicestatus = function(){
            $http.get("/StatusengineServicestatus/index.json", {
                params: {
                    'filter[StatusengineServicestatus.service_description]':$stateParams.serviceuuid
                }
            }).then(function(result){
                $scope.servicestatus = result.data.servicestatus[0];
            });
        };

        $scope.changepage = function(page){
            if(page !== $scope.currentPage){
                $scope.currentPage = page;
                $scope.load();
            }
        };

        $scope.$watchGroup(['stateOk', 'stateWarning', 'stateCritical', 'stateUnknown', 'filter_output'], function(){
            if($scope.init){
                return;
            }
            $scope.state = [];
            if($scope.stateOk){
                $scope.state.push('ok');
            }
            if($scope.stateWarning){
                $scope.state.push('warning');
            }
            if($scope.stateCritical){
                $scope.state.push('critical');
            }
            if($scope.stateUnknown){
                $scope.state.push('unknown');
            }
            $scope.load();
        });

        SortService.setCallback($scope.load);
        SortService.triggerReload();

        $scope.loadServicestatus();


        if ($("[rel=tooltip]").length) {
            $("[rel=tooltip]").tooltip();
        }

    });