angular.module('openITCOCKPIT')
    .controller('UsersController', function($scope, $http, SortService){
        $scope.paging = {};
        $scope.currentPage = 1;

        SortService.setSort('username');
        SortService.setDirection('asc');

        /** Filter Settings **/
        $scope.filter_username = '';
        $scope.filter_firstname = '';
        $scope.filter_lastname = '';
        /** Filter Settings **/


        $scope.init = true;
        $scope.load = function(){
            $http.get("/Users/index.json", {
                params: {
                    page: $scope.currentPage,
                    sort: SortService.getSort(),
                    direction: SortService.getDirection(),
                    'filter[Users.username]': $scope.filter_username,
                    'filter[Users.firstname]': $scope.filter_firstname,
                    'filter[Users.lastname]': $scope.filter_lastname
                }
            }).then(function(result){
                $scope.users = result.data.users;
                $scope.paging = result.data.paging;
                $scope.init = false;
            });
        };

        $scope.delete = function(id){
            $http.delete("/Users/delete/" + id).then(
                function(result){
                    new Noty({
                        type: 'success',
                        text: 'User deleted successfully',
                        layout: 'topCenter',
                        timeout: 4000,
                        animation: {
                            open: 'animated fadeInRight',
                            close: 'animated fadeOutRight'
                        }
                    }).show();
                    $scope.load();

                }, function errorCallback(result){
                    new Noty({
                        type: 'error',
                        text: 'Could not delete user',
                        layout: 'topCenter',
                        timeout: 4000,
                        animation: {
                            open: 'animated fadeInRight',
                            close: 'animated fadeOutRight'
                        }
                    }).show();
                });
        };

        $scope.$watchGroup(['filter_username', 'filter_firstname', 'filter_lastname'], function(){
            if($scope.init){
                return;
            }
            $scope.load();
        });

        $scope.changepage = function(page){
            if(page !== $scope.currentPage){
                $scope.currentPage = page;
                $scope.load();
            }
        };

        SortService.setCallback($scope.load);
        SortService.triggerReload();

    });