angular.module('openITCOCKPIT')
    .controller('UsersEditController', function($scope, $http, $state, $stateParams){

        $scope.errors = {};

        $scope.id = $stateParams.id;
        $scope.load = function(){
            $http.get("/Users/view/" + $scope.id + '.json').then(
                function(result){
                    $scope.post_username = result.data.user.username;
                    $scope.post_firstname = result.data.user.firstname;
                    $scope.post_lastname = result.data.user.lastname;

                }, function errorCallback(result){
                    var message = 'An error has occurred!';
                    if(result.status === 404){
                        message = 'User not found!';
                    }

                    new Noty({
                        type: 'error',
                        text: message,
                        layout: 'topCenter',
                        timeout: 4000,
                        animation: {
                            open: 'animated fadeInRight',
                            close: 'animated fadeOutRight'
                        }
                    }).show();
                    $state.go('users');
                });
        };

        $scope.submit = function(){

            $http.put("/Users/edit/" + $scope.id + ".json", {
                Users: {
                    username: $scope.post_username,
                    firstname: $scope.post_firstname,
                    lastname: $scope.post_lastname,
                    password: $scope.post_password,
                    password_confirm: $scope.post_password_confirm
                }
            }).then(function(result){
                new Noty({
                    type: 'success',
                    text: 'User updated successfully',
                    layout: 'topCenter',
                    timeout: 4000,
                    animation: {
                        open: 'animated fadeInRight',
                        close: 'animated fadeOutRight'
                    }
                }).show();

                $state.go('users');
            }, function errorCallback(result){
                if(result.data.hasOwnProperty('validationErrors')){
                    $scope.errors = result.data.validationErrors;
                }
            });

        };

        $scope.load();

    });