angular.module('openITCOCKPIT').directive('hoststatusdetailsmodal', function($http, $state){
    return {
        restrict: 'E',
        replace: true,
        templateUrl: '/StatusengineHoststatus/hoststatusdetailsmodal.html',

        controller: function($scope){

            $scope.loadHostDetails = function(hoststatus){
                $http.get("/StatusengineHoststatus/details.json", {
                    params: {
                        'uuid': hoststatus.hostname
                    }
                }).then(function(result){
                    $('#hostDetailsModal').modal('show');
                    $scope.hostdetails = result.data.hoststatus;
                });
            };

            $scope.goToHostDetails = function(){
                $('#hostDetailsModal').modal('hide');
                $('#hostDetailsModal').on('hidden.bs.modal', function () {
                    $state.go('hostdetails', {
                        uuid: $scope.hostdetails.hostname
                    });
                });
            };

        },

        link: function($scope, element, attr){
            $scope.showHostDetails = function(hoststatus) {
                $scope.loadHostDetails(hoststatus);
            }
        }
    };
});