angular.module('openITCOCKPIT').directive('servicestatusdetailsmodal', function($http, $state){
    return {
        restrict: 'E',
        replace: true,
        templateUrl: '/StatusengineServicestatus/servicestatusdetailsmodal.html',

        controller: function($scope){

            $scope.modalHostname = '';
            $scope.servicedetails = false;
            $scope.loadServiceDetails = function(servicestatus){
                $scope.modalHostname = servicestatus.MappingHost.display_name;
                $http.get("/StatusengineServicestatus/details.json", {
                    params: {
                        'serviceuuid': servicestatus.service_description
                    }
                }).then(function(result){
                    $('#serviceDetailsModal').modal('show');
                    $scope.servicedetails = result.data.servicestatus;
                });
            };

            $scope.goToServiceDetails = function(){
                $('#serviceDetailsModal').modal('hide');
                $('#serviceDetailsModal').on('hidden.bs.modal', function () {
                    $state.go('servicedetails', {
                        hostuuid: $scope.servicedetails.hostname,
                        serviceuuid: $scope.servicedetails.service_description
                    });
                });
            };

        },

        link: function($scope, element, attr){
            $scope.showServiceDetails = function(servicestatus) {
                $scope.loadServiceDetails(servicestatus);
            }
        }
    };
});