angular.module('openITCOCKPIT', ['ui.router', 'ui.bootstrap'])

    .factory("httpInterceptor", function($q, $rootScope, $timeout){
        return {
            response: function(result){
                $('#global_ajax_loader').fadeOut('slow');
                return result || $.then(result)
            },
            request: function(response){
                $('#global_ajax_loader').show();
                return response || $q.when(response);
            },
            responseError: function(rejection){
                $('#global_ajax_loader').fadeOut('slow');

                if(rejection.status === 401){
                    window.location = '/users/login';
                }

                return $q.reject(rejection);
            }
        };
    })

    .config(function($httpProvider){
        $httpProvider.interceptors.push("httpInterceptor");
    })

    .config(function($urlRouterProvider, $stateProvider){
        $urlRouterProvider.otherwise("/dashboard");

        $stateProvider
            .state('dashboard', {
                url: '/dashboard',
                templateUrl: "/Dashboard/index.html",
                controller: "DashboardController"
            })
            .state('hosts', {
                url: '/hosts/:statename',
                templateUrl: "/StatusengineHoststatus/index.html",
                controller: "HostController"
            })
            .state('services', {
                url: '/services/:statename/:hostdisplayname',
                templateUrl: "/StatusengineServicestatus/index.html",
                controller: "ServiceController"
            })
            .state('hostdetails', {
                url: '/hostdetails/:uuid',
                templateUrl: "/StatusengineHoststatus/details.html",
                controller: "HostDetailsController"
            })
            .state('hostchecks', {
                url: '/hostchecks/:uuid',
                templateUrl: "/StatusengineHostchecks/index.html",
                controller: "HostChecksController"
            })
            .state('hoststatehistory', {
                url: '/hoststatehistory/:uuid',
                templateUrl: "/StatusengineHostStatehistory/index.html",
                controller: "HostStatehistoryController"
            })
            .state('servicedetails', {
                url: '/servicedetails/:hostuuid/:serviceuuid',
                templateUrl: "/StatusengineServicestatus/details.html",
                controller: "ServiceDetailsController"
            })
            .state('servicechecks', {
                url: '/servicechecks/:serviceuuid',
                templateUrl: "/StatusengineServicechecks/index.html",
                controller: "ServiceChecksController"
            })
            .state('servicestatehistory', {
                url: '/servicestatehistory/:serviceuuid',
                templateUrl: "/StatusengineServiceStatehistory/index.html",
                controller: "ServiceStatehistoryController"
            })
            .state('automap', {
                url: '/automap',
                templateUrl: "/StatusengineServicestatus/automap.html",
                controller: "AutomapController"
            })
            .state('users', {
                url: '/users',
                templateUrl: "/Users/index.html",
                controller: "UsersController"
            })
            .state('users_add', {
                url: '/users/add',
                templateUrl: "/Users/add.html",
                controller: "UsersAddController"
            })
            .state('users_edit', {
                url: '/users/edit/:id',
                templateUrl: "/Users/add.html",
                controller: "UsersEditController"
            })


    })

    .filter('hostStatusName', function(){
        return function(hoststatusId){
            if(typeof hoststatusId === 'undefined'){
                return false;
            }

            switch(hoststatusId){
                case 0:
                    return 'Up';
                case 1:
                    return 'Down';
                default:
                    return 'Unreachable';
            }

        }
    })

    .filter('serviceStatusName', function(){
        return function(servicestatusId){
            if(typeof servicestatusId === 'undefined'){
                return false;
            }

            switch(servicestatusId){
                case 0:
                    return 'Ok';
                case 1:
                    return 'Warning';
                case 2:
                    return 'Critical';
                default:
                    return 'Unknown';
            }

        }
    })

    .filter('encodeURI', function(){
        return function(str){
            return encodeURI(str);
        }
    })

    .run(function($rootScope, SortService){

        $rootScope.getSortClass = function(field){
            if(field === SortService.getSort()){
                if(SortService.getDirection() === 'asc'){
                    return 'fa-sort-asc';
                }
                return 'fa-sort-desc';
            }

            return 'fa-sort';
        };

        $rootScope.orderBy = function(field){
            if(field !== SortService.getSort()){
                SortService.setDirection('asc');
                SortService.setSort(field);
                SortService.triggerReload();
                return;
            }

            if(SortService.getDirection() === 'asc'){
                SortService.setDirection('desc');
            }else{
                SortService.setDirection('asc');
            }
            SortService.triggerReload();
        };
    })
;
