<?php
/**
 * Statusengine Worker
 * Copyright (C) 2016  Daniel Ziegler
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

namespace Statusengine\Test\Backends\MySQL\SqlObjects;


use Statusengine\Mysql\SqlObjects\MysqlLogentry;


class MysqlLogentryTest extends \PHPUnit_Framework_TestCase {

    public function setUp() {
        parent::setUp(); // TODO: Change the autogenerated stub
        require_once __DIR__ . "/../../../lib/PdoMock.php";
        date_default_timezone_set('Europe/Berlin');
    }

    public function testInstanceOf() {
        $MysqlLogentry = new MysqlLogentry($this->getMockPdo(), $this->getMockBulkInsertObjectStore());
        $this->assertInstanceOf('\Statusengine\Mysql\SqlObjects\MysqlLogentry', $MysqlLogentry);
    }

    public function testBuildQuery() {
        $MysqlLogentry = new MysqlLogentry($this->getMockPdo(), $this->getMockBulkInsertObjectStore());

        $assert = 'INSERT INTO statusengine_logentries (entry_time, logentry_type, logentry_data)VALUES(?,?,?), (?,?,?)';
        $this->assertEquals($assert, $MysqlLogentry->buildQuery());
    }

    public function testInsert() {
        $MysqlLogentry = new MysqlLogentry($this->getMockPdo(), $this->getMockBulkInsertObjectStoreWithObjects(
            [$this->getMockLogentry(), $this->getMockLogentry()]
        ));


        $this->assertEquals([
            1 => '2017-01-07 07:17:31',
            2 => 1024,
            3 => 'This is a mock!',
            4 => '2017-01-07 07:17:31',
            5 => 1024,
            6 => 'This is a mock!',
        ], $MysqlLogentry->insert());
    }


    private function getMockPdo() {
        return new \PdoMock();
    }

    /**
     * @return \PHPUnit_Framework_MockObject_MockObject
     */
    private function getMockBulkInsertObjectStore() {
        $BulkInsertObjectStore = $this->getMockBuilder('Statusengine\BulkInsertObjectStore')
            ->disableOriginalConstructor()
            ->getMock();
        $BulkInsertObjectStore->expects($this->any())->method('getObjectCount')->will($this->returnValue(2));

        return $BulkInsertObjectStore;
    }

    private function getMockLogentry() {
        $Logentry = $this->getMockBuilder('Statusengine\ValueObjects\Logentry')
            ->disableOriginalConstructor()
            ->getMock();
        $Logentry->expects($this->any())->method('getEntryTime')->will($this->returnValue(1483769851));
        $Logentry->expects($this->any())->method('getLogentryType')->will($this->returnValue(1024));
        $Logentry->expects($this->any())->method('getLogentryData')->will($this->returnValue('This is a mock!'));
        return $Logentry;
    }

    /**
     * @return \PHPUnit_Framework_MockObject_MockObject
     */
    private function getMockBulkInsertObjectStoreWithObjects($objects) {
        $BulkInsertObjectStore = $this->getMockBuilder('Statusengine\BulkInsertObjectStore')
            ->disableOriginalConstructor()
            ->getMock();
        $BulkInsertObjectStore->expects($this->any())->method('getObjects')->will($this->returnValue($objects));

        return $BulkInsertObjectStore;
    }

}
