/*
 * Decompiled with CFR 0.152.
 */
package org.nagios;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.nagios.ParseError;

public class JMXQuery {
    private String url;
    private int verbatim;
    private JMXConnector connector;
    private MBeanServerConnection connection;
    private long warning;
    private long critical;
    private String attribute;
    private String info_attribute;
    private String attribute_key;
    private String info_key;
    private String username;
    private String password;
    private String object;
    private long checkData;
    private Object infoData;
    private static final int RETURN_OK = 0;
    private static final String OK_STRING = "JMX OK";
    private static final int RETURN_WARNING = 1;
    private static final String WARNING_STRING = "JMX WARNING";
    private static final int RETURN_CRITICAL = 2;
    private static final String CRITICAL_STRING = "JMX CRITICAL";
    private static final int RETURN_UNKNOWN = 3;
    private static final String UNKNOWN_STRING = "JMX UNKNOWN";

    private void connect() throws IOException {
        JMXServiceURL jmxUrl = new JMXServiceURL(this.url);
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        if (this.username != null) {
            env.put("jmx.remote.credentials", new String[]{this.username, this.password});
        }
        this.connector = JMXConnectorFactory.connect(jmxUrl, env);
        this.connection = this.connector.getMBeanServerConnection();
    }

    private void disconnect() throws IOException {
        if (this.connector != null) {
            this.connector.close();
            this.connector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int status;
        JMXQuery query = new JMXQuery();
        try {
            query.parse(args);
            query.connect();
            query.execute();
            int status2 = query.report(System.out);
            System.exit(status2);
        }
        catch (Exception ex) {
            status = query.report(ex, System.out);
            System.exit(status);
        }
        finally {
            try {
                query.disconnect();
            }
            catch (IOException e) {
                status = query.report(e, System.out);
                System.exit(status);
            }
        }
    }

    private int report(Exception ex, PrintStream out) {
        if (ex instanceof ParseError) {
            out.print("JMX UNKNOWN ");
            this.reportException(ex, out);
            out.println(" Usage: check_jmx -help ");
            return 3;
        }
        out.print("JMX CRITICAL ");
        this.reportException(ex, out);
        out.println();
        return 2;
    }

    private void reportException(Exception ex, PrintStream out) {
        if (this.verbatim < 2) {
            out.print(JMXQuery.rootCause(ex).getMessage());
        } else {
            out.print(ex.getMessage() + " connecting to " + this.object + " by URL " + this.url);
        }
        if (this.verbatim >= 3) {
            ex.printStackTrace(out);
        }
    }

    private static Throwable rootCause(Throwable ex) {
        if (ex.getCause() == null) {
            return ex;
        }
        return JMXQuery.rootCause(ex.getCause());
    }

    private int report(PrintStream out) {
        int status;
        if (this.compare(this.critical, this.warning < this.critical)) {
            status = 2;
            out.print("JMX CRITICAL ");
        } else if (this.compare(this.warning, this.warning < this.critical)) {
            status = 1;
            out.print("JMX WARNING ");
        } else {
            status = 0;
            out.print("JMX OK ");
        }
        if (this.infoData == null || this.verbatim >= 2) {
            if (this.attribute_key != null) {
                out.print(this.attribute + '.' + this.attribute_key + '=' + this.checkData);
            } else {
                out.print(this.attribute + '=' + this.checkData);
            }
        }
        if (this.infoData != null) {
            if (this.infoData instanceof CompositeDataSupport) {
                this.report((CompositeDataSupport)this.infoData, out);
            } else {
                out.print(this.infoData.toString());
            }
        }
        out.println();
        return status;
    }

    private void report(CompositeDataSupport data, PrintStream out) {
        CompositeType type = data.getCompositeType();
        out.print('{');
        Iterator<String> it = type.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            if (data.containsKey(key)) {
                out.print(key + '=' + data.get(key));
            }
            if (!it.hasNext()) continue;
            out.print(';');
        }
        out.print('}');
    }

    private boolean compare(long level, boolean more) {
        if (more) {
            return this.checkData >= level;
        }
        return this.checkData <= level;
    }

    private void execute() throws Exception {
        Object attr = this.connection.getAttribute(new ObjectName(this.object), this.attribute);
        if (attr instanceof CompositeDataSupport) {
            CompositeDataSupport cds = (CompositeDataSupport)attr;
            if (this.attribute_key == null) {
                throw new ParseError("Attribute key is null for composed data " + this.object);
            }
            this.checkData = this.parseData(cds.get(this.attribute_key));
        } else {
            this.checkData = this.parseData(attr);
        }
        if (this.info_attribute != null) {
            Object info_attr;
            Object object = info_attr = this.info_attribute.equals(this.attribute) ? attr : this.connection.getAttribute(new ObjectName(this.object), this.info_attribute);
            if (this.info_key != null && info_attr instanceof CompositeDataSupport && this.verbatim < 4) {
                CompositeDataSupport cds = (CompositeDataSupport)attr;
                this.infoData = cds.get(this.info_key);
            } else {
                this.infoData = info_attr;
            }
        }
    }

    private long parseData(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof Boolean) {
            boolean b = (Boolean)o;
            return b ? 1L : 0L;
        }
        return Long.parseLong(o.toString());
    }

    private void parse(String[] args) throws ParseError {
        try {
            for (int i = 0; i < args.length; ++i) {
                String option = args[i];
                if (option.equals("-help")) {
                    this.printHelp(System.out);
                    System.exit(3);
                    continue;
                }
                if (option.equals("-U")) {
                    this.url = args[++i];
                    continue;
                }
                if (option.equals("-O")) {
                    this.object = args[++i];
                    continue;
                }
                if (option.equals("-A")) {
                    this.attribute = args[++i];
                    continue;
                }
                if (option.equals("-I")) {
                    this.info_attribute = args[++i];
                    continue;
                }
                if (option.equals("-J")) {
                    this.info_key = args[++i];
                    continue;
                }
                if (option.equals("-K")) {
                    this.attribute_key = args[++i];
                    continue;
                }
                if (option.equals("-u")) {
                    this.username = args[++i];
                    continue;
                }
                if (option.equals("-p")) {
                    this.password = args[++i];
                    continue;
                }
                if (option.startsWith("-v")) {
                    this.verbatim = option.length() - 1;
                    continue;
                }
                if (option.equals("-w")) {
                    this.warning = Long.parseLong(args[++i]);
                    continue;
                }
                if (!option.equals("-c")) continue;
                this.critical = Long.parseLong(args[++i]);
            }
            if (this.url == null || this.object == null || this.attribute == null) {
                throw new Exception("Required options not specified");
            }
        }
        catch (Exception e) {
            throw new ParseError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printHelp(PrintStream out) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/nagios/Help.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String s;
            while ((s = reader.readLine()) != null) {
                out.println(s);
            }
        }
        catch (IOException e) {
            out.println(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                out.println(e);
            }
        }
    }
}

