/*
 * Decompiled with CFR 0.152.
 */
package livestatus;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import livestatus.LivestatusDatasource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.query.JRQueryExecuter;

public class LivestatusQueryExecuter
implements JRQueryExecuter {
    private HashMap<String, String> parameters;
    private String jasper_query;
    private String livestatus_query;
    private String server;
    private int server_port;
    private int timeoutInMs = 10000;
    private String fixed_appendix = "\nColumnHeaders: on\nResponseHeader: fixed16\nSeparators: 10 1 44 124\nOutputFormat: csv\n\n";
    private Socket socket;
    private OutputStream sockOutput;
    private InputStream sockInput;
    private BufferedReader in;

    public static void main(String[] stringArray) {
        try {
            String string = "localhost 6557\nGET statehist\nColumns: service_description time state duration duration_part log_output\nFilter: time >= 1351724400";
            LivestatusDatasource livestatusDatasource = new LivestatusQueryExecuter(string, null).createDatasource();
        }
        catch (JRException jRException) {
            jRException.printStackTrace();
        }
    }

    public LivestatusQueryExecuter(String string, Map map) {
        this.jasper_query = string;
        this.parameters = new HashMap();
        if (map != null) {
            for (Object k : map.keySet()) {
                if (map.get(k) == null) continue;
                this.parameters.put(k.toString(), map.get(k).toString());
            }
        }
    }

    public LivestatusQueryExecuter(JRDataset jRDataset, Map<String, ? extends JRValueParameter> map) {
        this.jasper_query = jRDataset.getQuery().getText();
        this.parameters = new HashMap();
        for (String string : map.keySet()) {
            if (map.get(string) == null || map.get(string).getValue() == null) continue;
            this.parameters.put(string.toString(), map.get(string).getValue().toString());
        }
    }

    private void evaluateQuery() throws JRException {
        for (String string2 : this.jasper_query.split("\n")) {
            if (!string2.trim().isEmpty()) continue;
            throw new JRException("LQL Query: Remove blank lines from query");
        }
        Object object = this.jasper_query;
        if (this.parameters != null) {
            for (String string : this.parameters.keySet()) {
                String string2;
                string2 = this.parameters.get(string);
                if (string2 == null) continue;
                object = ((String)object).replaceAll("\\$P\\{" + string + "\\}", "\"" + string2 + "\"");
                object = ((String)object).replaceAll("\\$P!\\{" + string + "\\}", string2);
            }
        }
        String string = ((String)object).split("\n")[0];
        this.livestatus_query = ((String)object).substring(string.length() + 1);
        this.server = string.split(" ")[0];
        this.server_port = Integer.parseInt(string.split(" ")[1]);
    }

    public boolean cancelQuery() throws JRException {
        try {
            if (this.socket.isConnected()) {
                this.socket.close();
                return true;
            }
        }
        catch (IOException iOException) {
            throw new JRException(iOException.getMessage());
        }
        return false;
    }

    public void close() {
    }

    private void setupSocket() throws JRException {
        try {
            InetAddress inetAddress = InetAddress.getByName(this.server);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, this.server_port);
            this.socket = new Socket();
            this.socket.connect(inetSocketAddress, this.timeoutInMs);
            this.sockOutput = this.socket.getOutputStream();
            this.sockInput = this.socket.getInputStream();
            this.in = new BufferedReader(new InputStreamReader(this.sockInput));
        }
        catch (Exception exception) {
            throw new JRException("Unable to connect to " + this.server + " " + this.server_port + " " + exception.getMessage());
        }
    }

    public LivestatusDatasource createDatasource() throws JRException {
        this.evaluateQuery();
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        try {
            this.setupSocket();
            String string = this.livestatus_query.split("\n")[0].split(" ")[1];
            String string2 = String.format("GET columns\nFilter: table = %s\nColumnHeaders: off\nResponseHeader: fixed16\nOutputFormat: csv\nSeparators:  10 1 44 124\nKeepAlive: on\n\n", string);
            this.sockOutput.write(string2.getBytes(), 0, string2.getBytes().length);
            String[] stringArray = this.in.readLine().split("\\s");
            int n = Integer.parseInt(stringArray[stringArray.length - 1]);
            int n2 = 0;
            String string3 = this.in.readLine();
            n2 += string3.getBytes().length + 1;
            while (n2 < n && (string3 = this.in.readLine()) != null) {
                n2 += string3.getBytes().length + 1;
                String[] stringArray2 = string3.split("\u0001");
                hashMap.put(stringArray2[1], stringArray2[0]);
                if (stringArray2[1].startsWith("stats_")) {
                    hashMap2.put(stringArray2[1], "float");
                    continue;
                }
                hashMap2.put(stringArray2[1], stringArray2[3]);
            }
            this.sockOutput.write(this.livestatus_query.getBytes(), 0, this.livestatus_query.getBytes().length);
            this.sockOutput.write(this.fixed_appendix.getBytes(), 0, this.fixed_appendix.getBytes().length);
            stringArray = this.in.readLine().split("\\s");
            if (!stringArray[0].equals("200")) {
                String string4 = "";
                while ((string3 = this.in.readLine()) != null) {
                    string4.concat(string3 + "\n");
                }
                throw new JRException("Livestatus response: \n" + stringArray + " \n" + string4);
            }
            n = Integer.parseInt(stringArray[stringArray.length - 1]);
            if (n > 0xA00000) {
                throw new JRException("Livestatus answer exceeds 10 MB. Aborting..");
            }
            n2 = 0;
            n2 += string3.getBytes().length + 1;
            while ((string3 = this.in.readLine()) != null) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (String string5 : string3.split("\u0001", -1)) {
                    arrayList2.add(string5);
                }
                arrayList.add(arrayList2);
            }
            this.sockInput.close();
            this.sockOutput.close();
            this.socket.close();
        }
        catch (JRException jRException) {
            throw jRException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JRException(String.format("Unable to process query: " + exception.getMessage(), new Object[0]));
        }
        return new LivestatusDatasource(arrayList, hashMap2, hashMap);
    }
}

