#!/usr/bin/env /usr/bin/python
import sys
if sys.version < '2.2':
  print("\n\n   You Must Have Python Version >= 2.2  To run saprfc \n\n")
  sys.exit(1)
import os
path = ""
if 'build' in os.listdir(os.getcwd()):
  path = os.path.join(os.getcwd(), 'build')
elif os.listdir(os.path.join(os.getcwd(), '../')):
  path = os.path.join(os.getcwd(), '../build')
else:
  print("cant find ./build directory to load the saprfc module, try runnig from the package root dir")
  print("   looked in:", os.getcwd(), " and ", os.path.join(os.getcwd(), '../'))
  sys.exit(1)
libdir = ""
for i in  os.listdir(path):
  if i.startswith("lib"):
    libdir = os.path.join(path, i)
if libdir == "":
  print("cant find ./build directory to load the saprfc module, try runnig from the package root dir")
  print("   looked in:", os.getcwd(), " and ", os.path.join(os.getcwd(), '../'))
  sys.exit(1)
sys.path.append(libdir)
print("using library path: " + libdir)


import sapnwrfc

sapnwrfc.base.config_location = 'examples/sap.yml'
sapnwrfc.base.load_config()

#conn = sapnwrfc.base.rfc_connect({'user': 'developer', 'passwd': 'developer'})
conn = sapnwrfc.base.rfc_connect()
print("connection attributes: ", conn.connection_attributes())
print("discover...")
fd = conn.discover("BAPI_BARCODE_SENDLIST")
print("finished discover...")
f = fd.create_function_call()
f.BARCODETABLE( [{ 'BARCODE': "BLAH BLAH", 'CONTREP': "B", 'DOCID': "000000000000000013", 'ARDATE': "20111201", 'DOCTYPE': "AT"}] )
print("do the call...")
f.invoke()
d = f.RETURN.value
print("NO. RETURN: ", len(f.RETURN()), " \n")
print("RETURN[0]: ", d, " \n")
conn.close()
