<?php

use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;

require __DIR__.'/../vendor/autoload.php';
$config['displayErrorDetails'] = true;
$app = new \Slim\App(["settings" => $config]);

$app->get('/nagios/', function (Request $request, Response $response) {
    $response->getBody()->write('Unknown API Request...');
});

//$app->get('/check_mk_api/discover/{task}[/{hostuuid}]', function (Request $request, Response $response) {
$app->get('/nagios/discover/{task}[/{hostuuid}]', function (Request $request, Response $response) {
    $task = $request->getAttribute('task');
    $checkMkBin = '/opt/openitc/nagios/3rd/check_mk/bin/check_mk';
    $checkMkAutochecks = '/opt/openitc/nagios/3rd/check_mk/var/check_mk/autochecks';

    switch($task){
        case 'dump-host':
            $hostuuid = $request->getAttribute('hostuuid');


            $autochecksPath = $checkMkAutochecks;
            if(is_dir($autochecksPath)){
                $files = [];
                foreach (new DirectoryIterator($autochecksPath) as $fileInfo) {
                    if (!$fileInfo->isDot()) {
                        $files[] = $fileInfo->getRealPath();
                    }
                }
                if(!empty($files)){

                    $Filesystem = new \Symfony\Component\Filesystem\Filesystem();
                    $Filesystem->remove($files);
                }
            }
            exec($checkMkBin . ' -II -v ' . $hostuuid, $output, $returncode);
            $output = null;
            exec($checkMkBin . ' -D ' . $hostuuid, $output, $returncode);
            break;

        case 'check-types':
            exec($checkMkBin. ' -L', $output, $returncode);
            break;

        case 'raw-info':
            $hostuuid = $request->getAttribute('hostuuid');
            exec($checkMkBin. ' -d ' . $hostuuid, $output, $returncode);
            break;

        default:
            $output = 'No task defined. Must be either {dump-host} for -II -v and -D, or {check-types} for -L, or {raw-info} for -d';

    }
    if(is_array($output)){
        $returnOutput = [];
        foreach($output as $key => $value){
            $returnOutput[$key] = iconv('latin1', 'UTF-8', $value);
        }
    }else{
        $returnOutput = iconv('latin1', 'UTF-8', $output);
    }

    //$response->getBody()->write(json_encode($returnOutput));
    //$newResponse = $response->withHeader('Content-type', 'application/json; charset=utf-8');
    $newResponse = $response->withJson($returnOutput);
    return $newResponse;
});
$app->run();
