#!/bin/bash

BIN=/usr/sbin/fsc-celsius-m470-sel

# Set the BIN path to current dir when it can not be found in
# the configured path
[ ! -f $BIN ] && BIN=./fsc-celsius-m470-sel

dmidecode --type 1 | grep "Product Name: CELSIUS M470" >/dev/null 2>&1
if [ $? -eq 0 ]; then
  OUT=`dmidecode --type 15`
  ADDR=`echo "$OUT" | grep 'Access Address' | cut -d':' -f2 | tr -d ' '`
  AREALEN=`echo "$OUT" | grep 'Area Length' | cut -d':' -f2 | tr -d ' ' | sed 's/bytes//g'`
  HEADLEN=`echo "$OUT" | grep 'Header Length' | cut -d':' -f2 | tr -d ' '`
  STATUS=`echo "$OUT" | grep 'Status' | cut -d':' -f2 | tr -d ' '`

  echo "<<<smbios_sel>>>"

  # Valid,Invalid output is a bug in current dmidecode. Valid,Full should
  # be the correct value when the eventlog is full.
  if [[ "$STATUS" == "Valid,Full" || "$STATUS" == "Valid,Invalid" ]]; then
    echo "E 0000-00-00 00:00:00 The Eventlog is invalid or full!"
  fi 
  
  $BIN $1 $ADDR $AREALEN
else
  echo "Unknown hardware." >&2
  exit 1
fi
